/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import jodd.db.ResultSetUtil;
import jodd.db.orm.DbEntityColumnDescriptor;
import jodd.db.orm.DbEntityDescriptor;
import jodd.db.orm.DbNameUtil;
import jodd.db.orm.meta.DbColumn;
import jodd.db.orm.meta.DbId;
import jodd.db.orm.meta.DbTable;
import jodd.db.type.SqlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMetaUtil {
    private static final String DATA_TYPE = "DATA_TYPE";

    public static String resolveTableName(Class<?> type, String tableNamePrefix, String tableNameSuffix, boolean toUpperCase) {
        String tableName = null;
        DbTable dbTable = type.getAnnotation(DbTable.class);
        if (dbTable != null) {
            tableName = dbTable.value().trim();
        }
        if (tableName == null || tableName.length() == 0) {
            tableName = DbNameUtil.convertClassNameToTableName(type, tableNamePrefix, tableNameSuffix, toUpperCase);
        }
        return tableName;
    }

    public static String resolveSchemaName(Class<?> type, String defaultSchemaName) {
        String schemaName = null;
        DbTable dbTable = type.getAnnotation(DbTable.class);
        if (dbTable != null) {
            schemaName = dbTable.schema().trim();
        }
        if (schemaName == null || schemaName.length() == 0) {
            schemaName = defaultSchemaName;
        }
        return schemaName;
    }

    public static boolean resolveIsAnnotated(Class<?> type) {
        DbTable dbTable = type.getAnnotation(DbTable.class);
        return dbTable != null;
    }

    public static DbEntityColumnDescriptor resolveColumnDescriptors(DbEntityDescriptor ded, Field field, boolean isAnnotated, boolean toUpperCase) {
        String columnName = null;
        boolean isId = false;
        Class<SqlType> sqlTypeClass = null;
        DbId dbId = field.getAnnotation(DbId.class);
        if (dbId != null) {
            columnName = dbId.value().trim();
            sqlTypeClass = dbId.sqlType();
            isId = true;
        } else {
            DbColumn dbColumn = field.getAnnotation(DbColumn.class);
            if (dbColumn != null) {
                columnName = dbColumn.value().trim();
                sqlTypeClass = dbColumn.sqlType();
            } else if (isAnnotated) {
                return null;
            }
        }
        if (columnName == null || columnName.length() == 0) {
            columnName = DbNameUtil.convertPropertyNameToColumnName(field.getName(), toUpperCase);
        }
        if (sqlTypeClass == SqlType.class) {
            sqlTypeClass = null;
        }
        return new DbEntityColumnDescriptor(ded, columnName, field.getName(), field.getType(), isId, sqlTypeClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resolveColumnDbSqlType(Connection connection, DbEntityColumnDescriptor dec) {
        if (dec.dbSqlType != Integer.MAX_VALUE) {
            return;
        }
        ResultSet rs = null;
        try {
            DbEntityDescriptor ded = dec.getDbEntityDescriptor();
            DatabaseMetaData dmd = connection.getMetaData();
            rs = dmd.getColumns(null, ded.getSchemaName(), ded.getTableName(), dec.getColumnName());
            dec.dbSqlType = rs.next() ? rs.getInt(DATA_TYPE) : Integer.MIN_VALUE;
            ResultSetUtil.close(rs);
        }
        catch (SQLException sex) {
            dec.dbSqlType = Integer.MIN_VALUE;
        }
        finally {
            ResultSetUtil.close(rs);
        }
    }
}

