/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jodd.db.DbQuery;
import jodd.db.DbSession;
import jodd.db.orm.DbEntityColumnDescriptor;
import jodd.db.orm.DbListIterator;
import jodd.db.orm.DbListOneIterator;
import jodd.db.orm.DbMetaUtil;
import jodd.db.orm.DbOrmManager;
import jodd.db.orm.DbSqlGenerator;
import jodd.db.orm.JoinHintResolver;
import jodd.db.orm.mapper.ResultSetMapper;
import jodd.db.orm.sqlgen.ParameterValue;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbOrmQuery
extends DbQuery {
    protected DbSqlGenerator sqlgen;
    protected DbOrmManager dbOrmManager = DbOrmManager.getInstance();
    protected String[] hints;
    protected JoinHintResolver hintResolver = this.dbOrmManager.getHintResolver();

    public DbOrmQuery(Connection conn, String sqlString) {
        super(conn, sqlString);
    }

    public static DbOrmQuery query(Connection conn, String sqlString) {
        return new DbOrmQuery(conn, sqlString);
    }

    public DbOrmQuery(DbSession session, String sqlString) {
        super(session, sqlString);
    }

    public static DbOrmQuery query(DbSession session, String sqlString) {
        return new DbOrmQuery(session, sqlString);
    }

    public DbOrmQuery(String sqlString) {
        super(sqlString);
    }

    public static DbOrmQuery query(String sqlString) {
        return new DbOrmQuery(sqlString);
    }

    public DbOrmQuery(Connection conn, DbSqlGenerator sqlgen) {
        super(conn, sqlgen.generateQuery());
        this.sqlgen = sqlgen;
    }

    public static DbOrmQuery query(Connection conn, DbSqlGenerator sqlgen) {
        return new DbOrmQuery(conn, sqlgen);
    }

    public DbOrmQuery(DbSession session, DbSqlGenerator sqlgen) {
        super(session, sqlgen.generateQuery());
        this.sqlgen = sqlgen;
    }

    public static DbOrmQuery query(DbSession session, DbSqlGenerator sqlgen) {
        return new DbOrmQuery(session, sqlgen);
    }

    public DbOrmQuery(DbSqlGenerator sqlgen) {
        super(sqlgen.generateQuery());
        this.sqlgen = sqlgen;
    }

    public static DbOrmQuery query(DbSqlGenerator sqlgen) {
        return new DbOrmQuery(sqlgen);
    }

    public DbOrmManager getManager() {
        return this.dbOrmManager;
    }

    @Override
    protected void prepareQuery() {
        Map<String, ParameterValue> parameters;
        super.prepareQuery();
        if (this.sqlgen == null) {
            return;
        }
        String[] joinHints = this.sqlgen.getJoinHints();
        if (joinHints != null) {
            this.withHints(joinHints);
        }
        if ((parameters = this.sqlgen.getQueryParameters()) == null) {
            return;
        }
        for (Map.Entry<String, ParameterValue> entry : parameters.entrySet()) {
            String paramName = entry.getKey();
            ParameterValue param = entry.getValue();
            DbEntityColumnDescriptor dec = param.getColumnDescriptor();
            if (dec == null) {
                this.setObject(paramName, param.getValue());
                continue;
            }
            DbMetaUtil.resolveColumnDbSqlType(this.connection, dec);
            this.setObject(paramName, param.getValue(), dec.getSqlTypeClass(), dec.getDbSqlType());
        }
    }

    public DbOrmQuery withHints(String hint) {
        this.hints = StringUtil.splitc((String)hint, (char)',');
        return this;
    }

    public DbOrmQuery withHints(String[] hints) {
        this.hints = hints;
        return this;
    }

    protected Object prepareRow(Object[] row) {
        return (row = this.hintResolver.join(row, this.hints)).length == 1 ? row[0] : row;
    }

    protected ResultSetMapper executeAndBuildResultSetMapper() {
        return this.createResultSetMapper(this.execute());
    }

    protected ResultSetMapper createResultSetMapper(ResultSet resultSet) {
        return this.dbOrmManager.createResultSetMapper(resultSet, this.sqlgen != null ? this.sqlgen.getColumnData() : null);
    }

    public <T> Iterator<T> iterateOne(Class<T> type) {
        return this.iterateOne(type, false);
    }

    public <T> Iterator<T> iterateOneAndClose(Class<T> type) {
        return this.iterateOne(type, true);
    }

    public <T> Iterator<T> iterateOne() {
        return this.iterateOne(null, false);
    }

    public <T> Iterator<T> iterateOneAndClose() {
        return this.iterateOne(null, true);
    }

    protected <T> Iterator<T> iterateOne(Class<T> type, boolean close) {
        return new DbListOneIterator<T>(this, type, close);
    }

    public <T> Iterator<T> iterate(Class ... types) {
        return this.iterate(types, false);
    }

    public <T> Iterator<T> iterateAndClose(Class ... types) {
        return this.iterate(types, true);
    }

    public <T> Iterator<T> iterate() {
        return this.iterate(null, false);
    }

    public <T> Iterator<T> iterateAndClose() {
        return this.iterate(null, true);
    }

    protected <T> Iterator<T> iterate(Class[] types, boolean close) {
        return new DbListIterator(this, types, close);
    }

    public <T> List<T> listOne(Class<T> type) {
        return this.listOne(type, 0, false);
    }

    public <T> List<T> listOneAndClose(Class<T> type) {
        return this.listOne(type, 0, true);
    }

    public <T> List<T> listOne() {
        return this.listOne(null, 0, false);
    }

    public <T> List<T> listOneAndClose() {
        return this.listOne(null, 0, true);
    }

    public <T> List<T> listOne(int max, Class<T> type) {
        return this.listOne(type, max, false);
    }

    public <T> List<T> listOneAndClose(int max, Class<T> type) {
        return this.listOne(type, max, true);
    }

    public <T> List<T> listOne(int max) {
        return this.listOne(null, max, false);
    }

    public <T> List<T> listOneAndClose(int max) {
        return this.listOne(null, max, true);
    }

    protected <T> List<T> listOne(Class<T> type, int max, boolean close) {
        Class[] classArray;
        ArrayList<Object> result = new ArrayList<Object>();
        ResultSetMapper rsm = this.executeAndBuildResultSetMapper();
        if (type == null) {
            classArray = rsm.resolveTables();
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        }
        Class[] types = classArray;
        while (rsm.next()) {
            result.add(rsm.parseOneObject(types));
            if (--max != 0) continue;
        }
        this.close(rsm, close);
        return result;
    }

    public <T> List<T> list(Class ... types) {
        return this.list(types, 0, false);
    }

    public <T> List<T> listAndClose(Class ... types) {
        return this.list(types, 0, true);
    }

    public <T> List<T> list() {
        return this.list(null, 0, false);
    }

    public <T> List<T> listAndClose() {
        return this.list(null, 0, true);
    }

    public <T> List<T> list(int max, Class ... types) {
        return this.list(types, max, false);
    }

    public <T> List<T> listAndClose(int max, Class ... types) {
        return this.list(types, max, true);
    }

    public <T> List<T> list(int max) {
        return this.list(null, max, false);
    }

    public <T> List<T> listAndClose(int max) {
        return this.list(null, max, true);
    }

    protected <T> List<T> list(Class[] types, int max, boolean close) {
        ArrayList<Object> result = new ArrayList<Object>();
        ResultSetMapper rsm = this.executeAndBuildResultSetMapper();
        if (types == null) {
            types = rsm.resolveTables();
        }
        while (rsm.next()) {
            result.add(this.prepareRow(rsm.parseObjects(types)));
            if (--max != 0) continue;
        }
        this.close(rsm, close);
        return result;
    }

    public <T> Set<T> listSetOne(Class<T> type) {
        return this.listSetOne(type, 0, false);
    }

    public <T> Set<T> listSetOneAndClose(Class<T> type) {
        return this.listSetOne(type, 0, true);
    }

    public <T> Set<T> listSetOne() {
        return this.listSetOne(null, 0, false);
    }

    public <T> Set<T> listSetOneAndClose() {
        return this.listSetOne(null, 0, true);
    }

    public <T> Set<T> listSetOne(int max, Class<T> type) {
        return this.listSetOne(type, max, false);
    }

    public <T> Set<T> listSetOneAndClose(int max, Class<T> type) {
        return this.listSetOne(type, max, true);
    }

    public <T> Set<T> listSetOne(int max) {
        return this.listSetOne(null, max, false);
    }

    public <T> Set<T> listSetOneAndClose(int max) {
        return this.listSetOne(null, max, true);
    }

    protected <T> Set<T> listSetOne(Class<T> type, int max, boolean close) {
        Class[] classArray;
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        ResultSetMapper rsm = this.executeAndBuildResultSetMapper();
        if (type == null) {
            classArray = rsm.resolveTables();
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        }
        Class[] types = classArray;
        while (rsm.next()) {
            result.add(rsm.parseOneObject(types));
            if (--max != 0) continue;
        }
        this.close(rsm, close);
        return result;
    }

    public <T> Set<T> listSet(Class ... types) {
        return this.listSet(types, 0, false);
    }

    public <T> Set<T> listSetAndClose(Class ... types) {
        return this.listSet(types, 0, true);
    }

    public <T> Set<T> listSet() {
        return this.listSet(null, 0, false);
    }

    public <T> Set<T> listSetAndClose() {
        return this.listSet(null, 0, true);
    }

    public <T> Set<T> listSet(int max, Class ... types) {
        return this.listSet(types, max, false);
    }

    public <T> Set<T> listSetAndClose(int max, Class ... types) {
        return this.listSet(types, max, true);
    }

    public <T> Set<T> listSet(int max) {
        return this.listSet(null, max, false);
    }

    public <T> Set<T> listSetAndClose(int max) {
        return this.listSet(null, max, true);
    }

    protected <T> Set<T> listSet(Class[] types, int max, boolean close) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        ResultSetMapper rsm = this.executeAndBuildResultSetMapper();
        if (types == null) {
            types = rsm.resolveTables();
        }
        while (rsm.next()) {
            result.add(this.prepareRow(rsm.parseObjects(types)));
            if (--max != 0) continue;
        }
        this.close(rsm, close);
        return result;
    }

    public <T> T findOne(Class<T> type) {
        return this.findOne(type, false, null);
    }

    public <T> T findOneAndClose(Class<T> type) {
        return this.findOne(type, true, null);
    }

    public Object findOne() {
        return this.findOne(null, false, null);
    }

    public Object findOneAndClose() {
        return this.findOne(null, true, null);
    }

    protected <T> T findOne(Class<T> type, boolean close, ResultSet resultSet) {
        Class[] classArray;
        ResultSetMapper rsm;
        if (resultSet == null) {
            resultSet = this.execute();
        }
        if (!(rsm = this.createResultSetMapper(resultSet)).next()) {
            return null;
        }
        if (type == null) {
            classArray = rsm.resolveTables();
        } else {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        }
        Class[] types = classArray;
        Object result = rsm.parseOneObject(types);
        this.close(rsm, close);
        return (T)result;
    }

    public Object find(Class ... types) {
        return this.find(types, false, null);
    }

    public Object findAndClose(Class ... types) {
        return this.find(types, true, null);
    }

    public Object find() {
        return this.find(null, false, null);
    }

    public Object findAndClose() {
        return this.find(null, true, null);
    }

    protected Object find(Class[] types, boolean close, ResultSet resultSet) {
        ResultSetMapper rsm;
        if (resultSet == null) {
            resultSet = this.execute();
        }
        if (!(rsm = this.createResultSetMapper(resultSet)).next()) {
            return null;
        }
        if (types == null) {
            types = rsm.resolveTables();
        }
        Object result = this.prepareRow(rsm.parseObjects(types));
        this.close(rsm, close);
        return result;
    }

    public <T> T findGeneratedKey(Class<T> type) {
        return this.findOne(type, false, this.getGeneratedColumns());
    }

    public Object findGeneratedColumns(Class ... types) {
        return this.find(types, false, this.getGeneratedColumns());
    }

    protected void close(ResultSetMapper rsm, boolean closeQuery) {
        if (closeQuery) {
            this.close();
        } else {
            this.closeResultSet(rsm.getResultSet());
        }
    }
}

