/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm;

import jodd.bean.BeanUtil;
import jodd.db.orm.DbEntityColumnDescriptor;
import jodd.db.orm.DbEntityDescriptor;
import jodd.db.orm.DbOrmQuery;

public class DbOrmUtil {
    public static void populateGeneratedKeys(Object entity, DbOrmQuery query) {
        String[] generatedColumns = query.getGeneratedColumnNames();
        if (generatedColumns == null) {
            return;
        }
        DbEntityDescriptor ded = query.getManager().lookupType(entity.getClass());
        Class[] keyTypes = new Class[generatedColumns.length];
        String[] properties = new String[generatedColumns.length];
        for (int i = 0; i < generatedColumns.length; ++i) {
            String column = generatedColumns[i];
            DbEntityColumnDescriptor decd = ded.findByColumnName(column);
            if (decd == null) continue;
            keyTypes[i] = decd.getPropertyType();
            properties[i] = decd.getPropertyName();
        }
        Object keyValues = query.findGeneratedColumns(keyTypes);
        if (!keyValues.getClass().isArray()) {
            BeanUtil.setDeclaredProperty((Object)entity, (String)properties[0], (Object)keyValues);
        } else {
            for (int i = 0; i < properties.length; ++i) {
                BeanUtil.setDeclaredProperty((Object)entity, (String)properties[i], (Object)((Object[])keyValues)[i]);
            }
        }
    }
}

