/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm.config;

import java.io.InputStream;
import java.net.URL;
import jodd.db.orm.DbOrmException;
import jodd.db.orm.DbOrmManager;
import jodd.db.orm.meta.DbTable;
import jodd.io.findfile.FindClass;
import jodd.util.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomagicDbOrmConfigurator
extends FindClass {
    private static final Logger log = LoggerFactory.getLogger(AutomagicDbOrmConfigurator.class);
    protected final byte[] dbTableAnnotationBytes = this.getTypeSignatureBytes(DbTable.class);
    protected final boolean registerAsEntities;
    protected DbOrmManager dbOrmManager;
    protected long elapsed;

    public AutomagicDbOrmConfigurator(boolean registerAsEntities) {
        this.registerAsEntities = registerAsEntities;
    }

    public AutomagicDbOrmConfigurator() {
        this(true);
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void configure(DbOrmManager dbOrmManager, URL[] classpath) {
        this.dbOrmManager = dbOrmManager;
        this.elapsed = System.currentTimeMillis();
        try {
            this.scanUrls(classpath);
        }
        catch (Exception ex) {
            throw new DbOrmException("Unable to scan classpath.", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        log.info("DbOrmManager configured in " + this.elapsed + " ms. Total entities: " + dbOrmManager.getTotalNames());
    }

    public void configure(DbOrmManager dbOrmManager) {
        this.configure(dbOrmManager, ClassLoaderUtil.getFullClassPath(AutomagicDbOrmConfigurator.class));
    }

    protected void onEntry(FindClass.EntryData entryData) {
        Class beanClass;
        String entryName = entryData.getName();
        InputStream inputStream = entryData.openInputStream();
        if (!this.isTypeSignatureInUse(inputStream, this.dbTableAnnotationBytes)) {
            return;
        }
        try {
            beanClass = this.loadClass(entryName);
        }
        catch (ClassNotFoundException cnfex) {
            throw new DbOrmException("Unable to load class: " + entryName, cnfex);
        }
        DbTable dbTable = beanClass.getAnnotation(DbTable.class);
        if (dbTable == null) {
            return;
        }
        if (this.registerAsEntities) {
            this.dbOrmManager.registerEntity(beanClass);
        } else {
            this.dbOrmManager.registerType(beanClass);
        }
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtil.loadClass((String)className, ((Object)((Object)this)).getClass());
    }
}

