/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm.sqlgen.chunks;

import jodd.bean.BeanUtil;
import jodd.db.orm.DbEntityColumnDescriptor;
import jodd.db.orm.DbEntityDescriptor;
import jodd.db.orm.sqlgen.chunks.SqlChunk;
import jodd.util.StringUtil;

public class UpdateSetChunk
extends SqlChunk {
    private static final String SET = "set ";
    protected final Object data;
    protected final String tableRef;
    protected final boolean includeNulls;

    public UpdateSetChunk(String tableRef, Object data, boolean includeNulls) {
        super(6);
        this.tableRef = tableRef;
        this.data = data;
        this.includeNulls = includeNulls;
    }

    public void process(StringBuilder out) {
        if (this.isPreviousChunkOfType(2)) {
            this.appendMissingSpace(out);
        }
        DbEntityDescriptor ded = this.tableRef != null ? this.lookupTableRef(this.tableRef) : this.lookupType(UpdateSetChunk.resolveClass(this.data));
        out.append(SET);
        DbEntityColumnDescriptor[] decList = ded.getColumnDescriptors();
        String typeName = StringUtil.uncapitalize((String)ded.getEntityName());
        String table = this.resolveTable(this.tableRef, ded);
        int size = 0;
        for (DbEntityColumnDescriptor dec : decList) {
            String property = dec.getPropertyName();
            Object value = BeanUtil.getDeclaredProperty((Object)this.data, (String)property);
            if (!this.includeNulls && value == null) continue;
            if (size > 0) {
                out.append(',').append(' ');
            }
            ++size;
            out.append(table).append('.').append(dec.getColumnName()).append('=');
            String propertyName = typeName + '.' + property;
            this.defineParameter(out, propertyName, value, dec);
        }
        if (size > 0) {
            out.append(' ');
        }
    }

    public SqlChunk clone() {
        return new UpdateSetChunk(this.tableRef, this.data, this.includeNulls);
    }
}

