/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx;

import jodd.jtx.JtxException;
import jodd.jtx.JtxIsolationLevel;
import jodd.jtx.JtxPropagationBehavior;
import jodd.util.HashCode;

public class JtxTransactionMode {
    protected JtxPropagationBehavior propagationBehavior = JtxPropagationBehavior.PROPAGATION_SUPPORTS;
    private JtxIsolationLevel isolationLevel = JtxIsolationLevel.ISOLATION_DEFAULT;
    public static final boolean READ_ONLY = true;
    public static final boolean READ_WRITE = false;
    private boolean readOnlyMode = true;
    public static final int DEFAULT_TIMEOUT = -1;
    private int timeout = -1;

    public JtxPropagationBehavior getPropagationBehavior() {
        return this.propagationBehavior;
    }

    public void setPropagationBehaviour(JtxPropagationBehavior propagation) {
        this.propagationBehavior = propagation;
    }

    public JtxTransactionMode propagationRequired() {
        this.propagationBehavior = JtxPropagationBehavior.PROPAGATION_REQUIRED;
        return this;
    }

    public JtxTransactionMode propagationSupports() {
        this.propagationBehavior = JtxPropagationBehavior.PROPAGATION_SUPPORTS;
        return this;
    }

    public JtxTransactionMode propagationMandatory() {
        this.propagationBehavior = JtxPropagationBehavior.PROPAGATION_MANDATORY;
        return this;
    }

    public JtxTransactionMode propagationRequiresNew() {
        this.propagationBehavior = JtxPropagationBehavior.PROPAGATION_REQUIRES_NEW;
        return this;
    }

    public JtxTransactionMode propagationNotSupported() {
        this.propagationBehavior = JtxPropagationBehavior.PROPAGATION_NOT_SUPPORTED;
        return this;
    }

    public JtxTransactionMode propagationNever() {
        this.propagationBehavior = JtxPropagationBehavior.PROPAGATION_NEVER;
        return this;
    }

    public JtxIsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(JtxIsolationLevel isolation) {
        this.isolationLevel = isolation;
    }

    public JtxTransactionMode isolationNone() {
        this.isolationLevel = JtxIsolationLevel.ISOLATION_NONE;
        return this;
    }

    public JtxTransactionMode isolationReadUncommitted() {
        this.isolationLevel = JtxIsolationLevel.ISOLATION_READ_UNCOMMITTED;
        return this;
    }

    public JtxTransactionMode isolationReadCommited() {
        this.isolationLevel = JtxIsolationLevel.ISOLATION_READ_COMMITTED;
        return this;
    }

    public JtxTransactionMode isolationRepeatableRead() {
        this.isolationLevel = JtxIsolationLevel.ISOLATION_REPEATABLE_READ;
        return this;
    }

    public JtxTransactionMode isolationSerializable() {
        this.isolationLevel = JtxIsolationLevel.ISOLATION_SERIALIZABLE;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnlyMode;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnlyMode = readOnly;
    }

    public JtxTransactionMode readOnly(boolean readOnly) {
        this.readOnlyMode = readOnly;
        return this;
    }

    public int getTransactionTimeout() {
        return this.timeout;
    }

    public void setTransactionTimeout(int timeout) {
        if (timeout < -1) {
            throw new JtxException("Invalid transaction timeout: '" + timeout + "'.");
        }
        this.timeout = timeout;
    }

    public JtxTransactionMode transactionTimeout(int timeout) {
        this.setTransactionTimeout(timeout);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JtxTransactionMode)) {
            return false;
        }
        JtxTransactionMode mode = (JtxTransactionMode)object;
        return mode.getPropagationBehavior() == this.propagationBehavior && mode.getIsolationLevel() == this.isolationLevel && mode.isReadOnly() == this.readOnlyMode && mode.getTransactionTimeout() == this.timeout;
    }

    public int hashCode() {
        int result = 173;
        result = HashCode.hash((int)result, (Object)((Object)this.propagationBehavior));
        result = HashCode.hash((int)result, (boolean)this.readOnlyMode);
        result = HashCode.hash((int)result, (Object)((Object)this.isolationLevel));
        result = HashCode.hash((int)result, (int)this.timeout);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("jtx{");
        sb.append(this.propagationBehavior.toString());
        sb.append(',').append(this.readOnlyMode ? "readonly" : "readwrite");
        sb.append(',').append(this.isolationLevel.toString());
        sb.append(',').append(this.timeout).append('}');
        return sb.toString();
    }
}

