/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.manager;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteException;
import jodd.petite.PetiteUtil;
import jodd.petite.meta.PetiteInject;

public class MethodResolver {
    protected final Map<Class, MethodInjectionPoint[]> methodRefs = new HashMap<Class, MethodInjectionPoint[]>();

    public MethodInjectionPoint[] resolve(Class type) {
        Method[] allMethods;
        MethodInjectionPoint[] methods = this.methodRefs.get(type);
        if (methods != null) {
            return methods;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        ArrayList<MethodInjectionPoint> list = new ArrayList<MethodInjectionPoint>();
        for (Method method : allMethods = cd.getAllMethods(true)) {
            PetiteInject ref = method.getAnnotation(PetiteInject.class);
            if (ref == null) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            String[] refNames = PetiteUtil.resolveParamReferences(ref.value(), paramTypes);
            if (refNames.length != paramTypes.length) {
                throw new PetiteException("Invalid number of method argument reference names for '" + type.getName() + '#' + method.getName() + '\'');
            }
            list.add(new MethodInjectionPoint(method, refNames));
        }
        methods = list.isEmpty() ? MethodInjectionPoint.EMPTY : list.toArray(new MethodInjectionPoint[list.size()]);
        this.methodRefs.put(type, methods);
        return methods;
    }
}

