/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.methref;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.WeakHashMap;
import jodd.proxetta.methref.MethrefException;
import jodd.proxetta.methref.MethrefProxetta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Methref<C> {
    protected static final MethrefProxetta proxetta = new MethrefProxetta();
    private static final Map<Class, Class> cache = new WeakHashMap<Class, Class>();
    private final C instance;

    public Methref(Class<C> target) {
        Class proxifiedTarget = cache.get(target);
        if (proxifiedTarget == null) {
            proxifiedTarget = proxetta.defineProxy(target);
            cache.put(target, proxifiedTarget);
        }
        try {
            this.instance = proxifiedTarget.newInstance();
        }
        catch (InstantiationException iex) {
            throw new MethrefException(iex);
        }
        catch (IllegalAccessException iaex) {
            throw new MethrefException(iaex);
        }
    }

    public static <T> T sref(Class<T> target) {
        return (T)Methref.on(target).instance;
    }

    public static <T> Methref<T> on(Class<T> target) {
        return new Methref<T>(target);
    }

    public String ref(int dummy) {
        return this.ref(null);
    }

    public String ref(short dummy) {
        return this.ref(null);
    }

    public String ref(byte dummy) {
        return this.ref(null);
    }

    public String ref(char dummy) {
        return this.ref(null);
    }

    public String ref(long dummy) {
        return this.ref(null);
    }

    public String ref(float dummy) {
        return this.ref(null);
    }

    public String ref(double dummy) {
        return this.ref(null);
    }

    public String ref(boolean dummy) {
        return this.ref(null);
    }

    public String ref(Object dummy) {
        if (dummy != null) {
            if (dummy instanceof String) {
                return (String)dummy;
            }
            throw new MethrefException("It seems that method reference was not collected with 'method()'.");
        }
        return this.ref();
    }

    public String ref() {
        if (this.instance == null) {
            return null;
        }
        try {
            Field f = this.instance.getClass().getDeclaredField("$__methodName$0");
            f.setAccessible(true);
            return f.get(this.instance).toString();
        }
        catch (NoSuchFieldException nsfex) {
            throw new MethrefException("Unable to find injected field.", nsfex);
        }
        catch (IllegalAccessException iaex) {
            throw new MethrefException("Unable to find injected field.", iaex);
        }
    }

    public C method() {
        return this.instance;
    }
}

