/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.pointcuts;

import java.lang.annotation.Annotation;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.ClassInfo;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxyPointcut;
import jodd.util.Wildcard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProxyPointcutSupport
implements ProxyPointcut {
    protected static final String SIGNATURE_OBJECT_CLASS = "java/lang/Object";

    public boolean isPublic(MethodInfo msign) {
        return (msign.getAccessFlags() & 1) != 0;
    }

    public AnnotationInfo lookupAnnotation(MethodInfo mi, Class<? extends Annotation> an) {
        AnnotationInfo[] anns = mi.getAnnotations();
        if (anns == null) {
            return null;
        }
        String anName = an.getName();
        for (AnnotationInfo ann : anns) {
            if (!ann.getAnnotationClassname().equals(anName)) continue;
            return ann;
        }
        return null;
    }

    public boolean hasAnnotation(MethodInfo mi, Class<? extends Annotation> ... an) {
        AnnotationInfo[] anns = mi.getAnnotations();
        if (anns == null) {
            return false;
        }
        for (Class<? extends Annotation> annotationClass : an) {
            String anName = annotationClass.getName();
            for (AnnotationInfo ann : anns) {
                if (!ann.getAnnotationClassname().equals(anName)) continue;
                return true;
            }
        }
        return false;
    }

    public AnnotationInfo lookupAnnotation(ClassInfo ci, Class<? extends Annotation> an) {
        AnnotationInfo[] anns = ci.getAnnotations();
        if (anns == null) {
            return null;
        }
        String anName = an.getName();
        for (AnnotationInfo ann : anns) {
            if (!ann.getAnnotationClassname().equals(anName)) continue;
            return ann;
        }
        return null;
    }

    public boolean hasAnnotation(ClassInfo ci, Class<? extends Annotation> ... an) {
        AnnotationInfo[] anns = ci.getAnnotations();
        if (anns == null) {
            return false;
        }
        for (Class<? extends Annotation> annotationClass : an) {
            String anName = annotationClass.getName();
            for (AnnotationInfo ann : anns) {
                if (!ann.getAnnotationClassname().equals(anName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNoArguments(MethodInfo msign) {
        return msign.getArgumentsCount() == 0;
    }

    public boolean hasOneArgument(MethodInfo msign) {
        return msign.getArgumentsCount() == 1;
    }

    public boolean isTopLevelMethod(MethodInfo msign) {
        return msign.isTopLevelMethod();
    }

    public boolean isRootMethod(MethodInfo msign) {
        return SIGNATURE_OBJECT_CLASS.equals(msign.getDeclaredClassName());
    }

    public boolean matchMethodName(MethodInfo msing, String wildcard) {
        return Wildcard.match((String)msing.getMethodName(), (String)wildcard);
    }

    public boolean matchClassName(MethodInfo msing, String wildcard) {
        return Wildcard.match((String)msing.getClassname(), (String)wildcard);
    }

    public boolean hasNoReturnValue(MethodInfo msign) {
        return msign.getReturnOpcodeType() == 86;
    }

    public boolean hasReturnValue(MethodInfo msign) {
        return msign.getReturnOpcodeType() != 86;
    }

    public boolean and(MethodInfo msign, ProxyPointcut p1, ProxyPointcut p2) {
        return p1.apply(msign) && p2.apply(msign);
    }

    public boolean or(MethodInfo msign, ProxyPointcut p1, ProxyPointcut p2) {
        return p1.apply(msign) || p2.apply(msign);
    }
}

