/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor.constraint;

import jodd.vtor.ValidationConstraint;
import jodd.vtor.ValidationConstraintContext;
import jodd.vtor.constraint.HasSubstring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasSubstringConstraint
implements ValidationConstraint<HasSubstring> {
    protected String substring;
    protected boolean ignoreCase;

    public HasSubstringConstraint() {
    }

    public HasSubstringConstraint(String substring, boolean ignoreCase) {
        this.substring = substring;
        this.ignoreCase = ignoreCase;
    }

    public String getSubstring() {
        return this.substring;
    }

    public void setSubstring(String substring) {
        this.substring = substring;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    @Override
    public void configure(HasSubstring annotation) {
        this.substring = annotation.value();
        this.ignoreCase = annotation.ignoreCase();
    }

    @Override
    public boolean isValid(ValidationConstraintContext vcc, Object value) {
        return HasSubstringConstraint.validate(value, this.substring, this.ignoreCase);
    }

    public static boolean validate(Object value, String substring, boolean ignoreCase) {
        if (value == null) {
            return true;
        }
        if (ignoreCase) {
            return value.toString().toLowerCase().indexOf(substring.toLowerCase()) > -1;
        }
        return value.toString().indexOf(substring) > -1;
    }
}

