/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import jodd.db.DbSession;
import jodd.db.DbSessionProvider;
import jodd.db.DbSqlException;
import jodd.db.DbThreadSession;
import jodd.db.ThreadDbSessionHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDbSessionProvider
implements DbSessionProvider {
    private static final Logger log = LoggerFactory.getLogger(ThreadDbSessionProvider.class);
    protected final boolean createIfMissing;

    public ThreadDbSessionProvider() {
        this(false);
    }

    public ThreadDbSessionProvider(boolean createIfMissing) {
        this.createIfMissing = createIfMissing;
    }

    public DbSession getDbSession() {
        log.debug("Requesting thread session");
        DbSession session = ThreadDbSessionHolder.get();
        if (session == null) {
            if (this.createIfMissing) {
                return new DbThreadSession();
            }
            throw new DbSqlException("No session associated to current thread.");
        }
        return session;
    }

    public void closeDbSession() {
        ThreadDbSessionProvider.closeThreadDbSession();
    }

    public static void closeThreadDbSession() {
        log.debug("Closing thread session");
        DbSession session = ThreadDbSessionHolder.get();
        if (session != null) {
            session.closeSession();
        }
    }
}

