/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm.sqlgen;

import java.util.Map;
import jodd.cache.Cache;
import jodd.cache.LRUCache;
import jodd.db.DbSession;
import jodd.db.orm.ColumnAliasType;
import jodd.db.orm.ColumnData;
import jodd.db.orm.DbOrmQuery;
import jodd.db.orm.DbSqlGenerator;
import jodd.db.orm.sqlgen.DbSqlBuilderException;
import jodd.db.orm.sqlgen.ParameterValue;
import jodd.db.orm.sqlgen.TemplateData;
import jodd.db.orm.sqlgen.TemplateParser;
import jodd.db.orm.sqlgen.chunks.ColumnValueChunk;
import jodd.db.orm.sqlgen.chunks.ColumnsSelectChunk;
import jodd.db.orm.sqlgen.chunks.InsertChunk;
import jodd.db.orm.sqlgen.chunks.MatchChunk;
import jodd.db.orm.sqlgen.chunks.RawSqlChunk;
import jodd.db.orm.sqlgen.chunks.ReferenceChunk;
import jodd.db.orm.sqlgen.chunks.SqlChunk;
import jodd.db.orm.sqlgen.chunks.TableChunk;
import jodd.db.orm.sqlgen.chunks.UpdateSetChunk;
import jodd.db.orm.sqlgen.chunks.ValueChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSqlBuilder
extends TemplateData
implements DbSqlGenerator {
    protected static Cache<String, SqlChunk> cache = new LRUCache(100);
    protected static int cacheThreshold = 3;
    protected SqlChunk firstChunk;
    protected SqlChunk lastChunk;
    protected int totalChunks;
    protected static final TemplateParser templateParser = new TemplateParser();

    public DbSqlBuilder() {
    }

    public DbSqlBuilder(String template) {
        this.append(template);
    }

    public static DbSqlBuilder sql() {
        return new DbSqlBuilder();
    }

    public static DbSqlBuilder sql(String template) {
        SqlChunk cloned;
        if (cache == null) {
            return new DbSqlBuilder().append(template);
        }
        SqlChunk cachedChunk = (SqlChunk)cache.get((Object)template);
        if (cachedChunk == null) {
            DbSqlBuilder dbsql = new DbSqlBuilder().append(template);
            if (dbsql.totalChunks >= cacheThreshold) {
                cachedChunk = DbSqlBuilder.cloneAllChunks(dbsql.firstChunk);
                cache.put((Object)template, (Object)cachedChunk);
            }
            return dbsql;
        }
        DbSqlBuilder dbsql = new DbSqlBuilder();
        dbsql.firstChunk = cloned = DbSqlBuilder.cloneAllChunks(cachedChunk);
        while (cloned != null) {
            dbsql.lastChunk = cloned;
            cloned = cloned.getNextChunk();
        }
        return dbsql;
    }

    public DbSqlBuilder reset() {
        this.resetAll();
        return this;
    }

    public static void setCacheThreshold(int ct) {
        if (ct < 1) {
            throw new DbSqlBuilderException("Cache threshold can't be less then 1 (" + ct + ").");
        }
        cacheThreshold = ct;
    }

    public static void setCacheSize(int size) {
        cache = size <= 0 ? null : new LRUCache(size);
    }

    protected static SqlChunk cloneAllChunks(SqlChunk chunk) {
        SqlChunk first;
        if (chunk == null) {
            return null;
        }
        SqlChunk previous = first = chunk.clone();
        for (chunk = chunk.getNextChunk(); chunk != null; chunk = chunk.getNextChunk()) {
            SqlChunk cloned = chunk.clone();
            cloned.insertChunkAfter(previous);
            previous = cloned;
        }
        return first;
    }

    public DbSqlBuilder aliasColumnsAs(ColumnAliasType aliasesType) {
        this.columnAliasType = aliasesType;
        return this;
    }

    public DbSqlBuilder use(String name, Object value) {
        this.setObjectReference(name, value);
        return this;
    }

    protected DbSqlBuilder addChunk(SqlChunk chunk) {
        if (this.lastChunk == null) {
            this.lastChunk = this.firstChunk = chunk;
        } else {
            chunk.insertChunkAfter(this.lastChunk);
            this.lastChunk = chunk;
        }
        ++this.totalChunks;
        return this;
    }

    public DbSqlBuilder append(String text) {
        templateParser.parse(this, text);
        return this;
    }

    public DbSqlBuilder appendRaw(String text) {
        this.addChunk(new RawSqlChunk(text));
        return this;
    }

    public DbSqlBuilder _(String text) {
        return this.append(text);
    }

    public DbSqlBuilder _() {
        return this.appendRaw(" ");
    }

    @Override
    public String generateQuery() {
        SqlChunk chunk;
        this.resetOnPreInit();
        for (chunk = this.firstChunk; chunk != null; chunk = chunk.getNextChunk()) {
            chunk.init(this);
        }
        StringBuilder query = new StringBuilder();
        try {
            for (chunk = this.firstChunk; chunk != null; chunk = chunk.getNextChunk()) {
                chunk.process(query);
            }
        }
        catch (DbSqlBuilderException dsbex) {
            dsbex.setQueryString(query.toString());
            throw dsbex;
        }
        return query.toString();
    }

    @Override
    public Map<String, ColumnData> getColumnData() {
        return this.columnData;
    }

    @Override
    public Map<String, ParameterValue> getQueryParameters() {
        return this.parameters;
    }

    @Override
    public String[] getJoinHints() {
        if (this.hints == null) {
            return null;
        }
        return this.hints.toArray(new String[this.hints.size()]);
    }

    public DbSqlBuilder table(String entityName) {
        return this.addChunk(new TableChunk(entityName));
    }

    public DbSqlBuilder table(String entityName, String alias) {
        return this.addChunk(new TableChunk(entityName, alias));
    }

    public DbSqlBuilder table(Object entity, String alias) {
        return this.addChunk(new TableChunk(entity, alias));
    }

    public DbSqlBuilder table(Object entity) {
        return this.addChunk(new TableChunk(entity));
    }

    public DbSqlBuilder column(String reference) {
        return this.addChunk(new ColumnsSelectChunk(reference));
    }

    public DbSqlBuilder column(String tableRef, String columnRef) {
        return this.addChunk(new ColumnsSelectChunk(tableRef, columnRef));
    }

    public DbSqlBuilder columnsAll(String tableRef) {
        return this.addChunk(new ColumnsSelectChunk(tableRef, true));
    }

    public DbSqlBuilder columnsIds(String tableRef) {
        return this.addChunk(new ColumnsSelectChunk(tableRef, false));
    }

    public DbSqlBuilder ref(String columnRef) {
        return this.addChunk(new ReferenceChunk(columnRef));
    }

    public DbSqlBuilder ref(String tableRef, String columnRef) {
        return this.addChunk(new ReferenceChunk(tableRef, columnRef, false));
    }

    public DbSqlBuilder refId(String tableRef) {
        return this.addChunk(new ReferenceChunk(tableRef, null, true));
    }

    public DbSqlBuilder match(String tableRef, Object value) {
        return this.addChunk(new MatchChunk(tableRef, value, 1));
    }

    public DbSqlBuilder match(String tableRef, String objectRef) {
        return this.addChunk(new MatchChunk(tableRef, objectRef, 1));
    }

    public DbSqlBuilder matchIds(String tableRef, Object value) {
        return this.addChunk(new MatchChunk(tableRef, value, 2));
    }

    public DbSqlBuilder matchIds(String tableRef, String objectRef) {
        return this.addChunk(new MatchChunk(tableRef, objectRef, 2));
    }

    public DbSqlBuilder matchAll(String tableRef, Object value) {
        return this.addChunk(new MatchChunk(tableRef, value, 3));
    }

    public DbSqlBuilder matchAll(String tableRef, String objectRef) {
        return this.addChunk(new MatchChunk(tableRef, objectRef, 3));
    }

    public DbSqlBuilder match(String expression) {
        return this.addChunk(new MatchChunk(expression));
    }

    public DbSqlBuilder value(String name, Object value) {
        return this.addChunk(new ValueChunk(name, value));
    }

    public DbSqlBuilder value(Object value) {
        return this.addChunk(new ValueChunk(null, value));
    }

    public DbSqlBuilder valueRef(String objectReference) {
        return this.addChunk(new ValueChunk(objectReference));
    }

    public DbSqlBuilder colvalue(String name, Object value) {
        return this.addChunk(new ColumnValueChunk(name, value));
    }

    public DbSqlBuilder colvalue(Object value) {
        return this.addChunk(new ColumnValueChunk(null, value));
    }

    public DbSqlBuilder colvalueRef(String objectReference) {
        return this.addChunk(new ColumnValueChunk(objectReference));
    }

    public DbSqlBuilder insert(String entityName, Object values) {
        return this.addChunk(new InsertChunk(entityName, values));
    }

    public DbSqlBuilder insert(Class entity, Object values) {
        return this.addChunk(new InsertChunk(entity, values));
    }

    public DbSqlBuilder insert(Object values) {
        return this.addChunk(new InsertChunk(values.getClass(), values));
    }

    public DbSqlBuilder set(String tableRef, Object values) {
        return this.addChunk(new UpdateSetChunk(tableRef, values, false));
    }

    public DbSqlBuilder setAll(String tableRef, Object values) {
        return this.addChunk(new UpdateSetChunk(tableRef, values, true));
    }

    public DbOrmQuery query() {
        return new DbOrmQuery(this);
    }

    public DbOrmQuery query(DbSession session) {
        return new DbOrmQuery(session, (DbSqlGenerator)this);
    }
}

