/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.orm.sqlgen.chunks;

import jodd.db.orm.DbEntityColumnDescriptor;
import jodd.db.orm.DbEntityDescriptor;
import jodd.db.orm.sqlgen.DbSqlBuilderException;
import jodd.db.orm.sqlgen.chunks.SqlChunk;

public class ReferenceChunk
extends SqlChunk {
    protected final String tableRef;
    protected final String columnRef;
    protected final boolean onlyId;

    public ReferenceChunk(String tableRef, String columnRef) {
        this(tableRef, columnRef, false);
    }

    public ReferenceChunk(String tableRef, String columnRef, boolean onlyId) {
        super(3);
        this.tableRef = tableRef;
        this.columnRef = columnRef;
        this.onlyId = onlyId;
    }

    public ReferenceChunk(String reference) {
        super(3);
        int dotNdx = reference.indexOf(46);
        if (dotNdx == -1) {
            this.tableRef = reference;
            this.columnRef = null;
            this.onlyId = false;
        } else {
            this.tableRef = reference.substring(0, dotNdx);
            this.columnRef = reference.substring(dotNdx + 1);
            this.onlyId = this.columnRef != null && this.columnRef.equals("+");
        }
    }

    public void process(StringBuilder out) {
        DbEntityDescriptor ded = this.lookupTableRef(this.tableRef);
        out.append(this.resolveTable(this.tableRef, ded));
        if (this.onlyId) {
            out.append('.').append(ded.getIdColumnName());
        } else if (this.columnRef != null) {
            String column;
            DbEntityColumnDescriptor dec;
            this.templateData.lastColumnDec = dec = ded.findByPropertyName(this.columnRef);
            String string = column = dec == null ? null : dec.getColumnName();
            if (column == null) {
                throw new DbSqlBuilderException("Unable to resolve column reference: '" + this.tableRef + '.' + this.columnRef + "'.");
            }
            out.append('.').append(column);
        }
    }

    public SqlChunk clone() {
        return new ReferenceChunk(this.tableRef, this.columnRef, this.onlyId);
    }
}

