/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx.db;

import jodd.db.DbSession;
import jodd.db.DbSessionProvider;
import jodd.db.DbSqlException;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.JtxTransactionMode;
import jodd.jtx.db.DbJtxTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbJtxSessionProvider
implements DbSessionProvider {
    private static final Logger log = LoggerFactory.getLogger(DbJtxSessionProvider.class);
    protected final JtxTransactionManager jtxTxManager;
    protected final JtxTransactionMode defaultTxMode;

    public DbJtxSessionProvider(JtxTransactionManager txManager) {
        this(txManager, null);
    }

    public DbJtxSessionProvider(JtxTransactionManager txManager, JtxTransactionMode defaultTxMode) {
        this.jtxTxManager = txManager;
        this.defaultTxMode = defaultTxMode;
    }

    public DbSession getDbSession() {
        log.debug("Requesting db TX manager session");
        DbJtxTransaction jtx = (DbJtxTransaction)this.jtxTxManager.getTransaction();
        if (jtx == null) {
            if (this.defaultTxMode != null) {
                jtx = (DbJtxTransaction)this.jtxTxManager.requestTransaction(this.defaultTxMode, null);
                return jtx.requestResource();
            }
            throw new DbSqlException("No transaction is in progress and DbSession can't be provided. It seems that transaction manager is not used to begin a transaction.");
        }
        return jtx.requestResource();
    }

    public void closeDbSession() {
        log.debug("Closing db TX manager session");
        DbJtxTransaction jtx = (DbJtxTransaction)this.jtxTxManager.getTransaction();
        if (jtx != null) {
            jtx.commit();
        }
    }
}

