/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jodd.introspector.ClassIntrospector;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ActionConfigSet;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.component.MadvocConfig;
import jodd.petite.meta.PetiteInject;
import jodd.util.BinarySearch;
import jodd.util.ClassLoaderUtil;
import jodd.util.collection.SortedArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionsManager {
    private static final Logger log = LoggerFactory.getLogger(ActionsManager.class);
    @PetiteInject
    protected ActionMethodParser actionMethodParser;
    @PetiteInject
    protected MadvocConfig madvocConfig;
    protected int actionsCount;
    protected final HashMap<String, ActionConfigSet> map = new HashMap();
    protected final SortedArrayList<ActionConfigSet> list = new SortedArrayList();
    protected final ActionPathChunksBinarySearch listMatch = new ActionPathChunksBinarySearch();
    protected final BinarySearch<ActionConfigSet> listBS = BinarySearch.forList(this.list);

    public List<ActionConfig> getAllActionConfigurations() {
        ArrayList<ActionConfig> all = new ArrayList<ActionConfig>(this.actionsCount);
        for (ActionConfigSet set : this.map.values()) {
            all.addAll(set.getActionConfigs());
        }
        for (ActionConfigSet set : this.list) {
            all.addAll(set.getActionConfigs());
        }
        return all;
    }

    public int getActionsCount() {
        return this.actionsCount;
    }

    public ActionConfig register(String actionSignature) {
        return this.register(actionSignature, null);
    }

    public ActionConfig register(String actionSignature, String actionPath) {
        Class actionClass;
        int ndx = actionSignature.indexOf(35);
        if (ndx == -1) {
            throw new MadvocException("Madvoc action signature syntax error: '" + actionSignature + "'.");
        }
        String actionClassName = actionSignature.substring(0, ndx);
        String actionMethodName = actionSignature.substring(ndx + 1);
        try {
            actionClass = ClassLoaderUtil.loadClass((String)actionClassName, this.getClass());
        }
        catch (ClassNotFoundException cnfex) {
            throw new MadvocException("Madvoc action class not found: '" + actionClassName + "'.", cnfex);
        }
        return this.register(actionClass, actionMethodName, actionPath);
    }

    public ActionConfig register(Class actionClass, String actionMethod) {
        return this.register(actionClass, actionMethod, null);
    }

    public ActionConfig register(Class actionClass, String actionMethod, String actionPath) {
        Method method = ClassIntrospector.lookup((Class)actionClass).getMethod(actionMethod);
        if (method == null) {
            throw new MadvocException("Provided action class '" + actionClass.getSimpleName() + "' doesn't contain public method '" + actionMethod + "'.");
        }
        return this.registerAction(actionClass, method, actionPath);
    }

    public ActionConfig register(Class actionClass, Method actionMethod, String actionPath) {
        return this.registerAction(actionClass, actionMethod, actionPath);
    }

    public ActionConfig register(Class actionClass, Method actionMethod) {
        return this.registerAction(actionClass, actionMethod, null);
    }

    protected ActionConfig registerAction(Class actionClass, Method actionMethod, String actionPath) {
        ActionConfig cfg = this.actionMethodParser.parse(actionClass, actionMethod, actionPath);
        if (cfg == null) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Registering Madvoc action: " + cfg.actionPath + " to: " + cfg.actionClass.getName() + '#' + cfg.actionClassMethod.getName());
        }
        ActionConfigSet set = new ActionConfigSet(cfg.actionPath);
        if (set.actionPathMacros != null) {
            int ndx = this.listBS.find((Object)set);
            if (ndx < 0) {
                this.list.add((Object)set);
            } else {
                set = (ActionConfigSet)this.list.get(ndx);
            }
        } else if (!this.map.containsKey(cfg.actionPath)) {
            this.map.put(cfg.actionPath, set);
        } else {
            set = this.map.get(cfg.actionPath);
        }
        boolean isDuplicate = set.add(cfg);
        if (!isDuplicate) {
            ++this.actionsCount;
        }
        if (this.madvocConfig.isDetectDuplicatePathsEnabled() && isDuplicate) {
            throw new MadvocException("Duplicate action path for '" + cfg + "'.");
        }
        return cfg;
    }

    public ActionConfig lookup(String actionPath, String[] actionChunks, String method) {
        ActionConfig actionConfig;
        ActionConfigSet acset = this.map.get(actionPath);
        if (acset != null && (actionConfig = acset.lookup(method)) != null) {
            return actionConfig;
        }
        int low = 0;
        int high = this.list.size() - 1;
        int macroNdx = 0;
        for (int deep = 0; deep < actionChunks.length; ++deep) {
            String chunk = actionChunks[deep];
            this.listMatch.deep = deep;
            int nextLow = this.listMatch.findFirst(chunk, low, high);
            if (nextLow < 0) {
                int matched = this.matchChunk(chunk, deep, macroNdx, low, high);
                if (matched == -1) {
                    low = nextLow;
                    break;
                }
                ++macroNdx;
                low = matched;
                high = matched;
                continue;
            }
            low = nextLow;
            if (high <= low) continue;
            high = this.listMatch.findLast(chunk, low, high);
        }
        if (low < 0) {
            return null;
        }
        ActionConfigSet set = (ActionConfigSet)this.list.get(low);
        ActionConfig cfg = set.lookup(method);
        if (cfg == null) {
            return null;
        }
        if (set.actionPathChunks.length != actionChunks.length) {
            return null;
        }
        return cfg;
    }

    protected int matchChunk(String chunk, int chunkNdx, int macroNdx, int low, int high) {
        for (int i = low; i <= high; ++i) {
            String value;
            ActionConfigSet set = (ActionConfigSet)this.list.get(i);
            if (macroNdx >= set.actionPathMacros.length) continue;
            ActionConfigSet.PathMacro macro = set.actionPathMacros[macroNdx];
            if (macro.ndx != chunkNdx || !chunk.startsWith(macro.left) || !chunk.endsWith(macro.right) || macro.pattern != null && !macro.pattern.matcher(value = chunk.substring(macro.left.length(), chunk.length() - macro.right.length())).matches()) continue;
            return i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ActionPathChunksBinarySearch
    extends BinarySearch<String> {
        protected int deep;

        protected ActionPathChunksBinarySearch() {
        }

        protected String get(int index, int deep) {
            return ((ActionConfigSet)ActionsManager.this.list.get((int)index)).actionPathChunks[deep];
        }

        protected int compare(int index, String element) {
            return this.get(index, this.deep).compareTo(element);
        }

        protected int getLastIndex() {
            return ActionsManager.this.list.size() - 1;
        }
    }
}

