/*
 * Decompiled with CFR 0.152.
 */
package jodd.paramo;

import jodd.asm.EmptyMethodVisitor;
import org.objectweb.asm.Label;

final class ParamExtractor
extends EmptyMethodVisitor {
    private final int paramCount;
    private final int ignoreCount;
    private final StringBuilder result;
    private int currentParam;
    boolean debugInfoPresent;

    ParamExtractor(int ignoreCount, int paramCount) {
        this.ignoreCount = ignoreCount;
        this.paramCount = paramCount;
        this.result = new StringBuilder();
        this.currentParam = 0;
        this.debugInfoPresent = paramCount == 0;
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (index >= this.ignoreCount && index < this.ignoreCount + this.paramCount) {
            if (!name.equals("arg" + this.currentParam)) {
                this.debugInfoPresent = true;
            }
            this.result.append(',');
            this.result.append(name);
            ++this.currentParam;
        }
    }

    String getResult() {
        return this.result.length() != 0 ? this.result.substring(1) : "";
    }
}

