/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.petite.InjectionPointFactory;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.meta.PetiteInject;

public class PropertyResolver {
    protected final Map<Class, PropertyInjectionPoint[]> properties = new HashMap<Class, PropertyInjectionPoint[]>();
    protected final InjectionPointFactory injectionPointFactory;

    public PropertyResolver(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public PropertyInjectionPoint[] resolve(Class type, boolean autowire) {
        Field[] allFields;
        PropertyInjectionPoint[] fields = this.properties.get(type);
        if (fields != null) {
            return fields;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        ArrayList<PropertyInjectionPoint> list = new ArrayList<PropertyInjectionPoint>();
        for (Field field : allFields = cd.getAllFields(true)) {
            String name;
            PetiteInject ref = field.getAnnotation(PetiteInject.class);
            if (!autowire && ref == null) continue;
            String[] refName = null;
            if (ref != null && (name = ref.value().trim()).length() != 0) {
                refName = new String[]{name};
            }
            list.add(this.injectionPointFactory.createPropertyInjectionPoint(field, refName));
        }
        fields = list.isEmpty() ? PropertyInjectionPoint.EMPTY : list.toArray(new PropertyInjectionPoint[list.size()]);
        this.properties.put(type, fields);
        return fields;
    }

    public void remove(Class type) {
        this.properties.remove(type);
    }
}

