/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.config;

import java.io.File;
import java.io.InputStream;
import jodd.db.oom.DbOomException;
import jodd.db.oom.DbOomManager;
import jodd.db.oom.meta.DbTable;
import jodd.io.findfile.ClassFinder;
import jodd.log.Log;
import jodd.util.ClassLoaderUtil;

public class AutomagicDbOomConfigurator
extends ClassFinder {
    private static final Log log = Log.getLogger(AutomagicDbOomConfigurator.class);
    protected final byte[] dbTableAnnotationBytes = this.getTypeSignatureBytes(DbTable.class);
    protected final boolean registerAsEntities;
    protected DbOomManager dbOomManager;
    protected long elapsed;

    public AutomagicDbOomConfigurator(boolean registerAsEntities) {
        this.registerAsEntities = registerAsEntities;
    }

    public AutomagicDbOomConfigurator() {
        this(true);
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void configure(DbOomManager dbOomManager, File[] classpath) {
        this.dbOomManager = dbOomManager;
        this.elapsed = System.currentTimeMillis();
        try {
            this.scanPaths(classpath);
        }
        catch (Exception ex) {
            throw new DbOomException("Unable to scan classpath.", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        log.info("DbOomManager configured in " + this.elapsed + " ms. Total entities: " + dbOomManager.getTotalNames());
    }

    public void configure(DbOomManager dbOomManager) {
        this.configure(dbOomManager, ClassLoaderUtil.getDefaultClasspath());
    }

    protected void onEntry(ClassFinder.EntryData entryData) {
        Class beanClass;
        String entryName = entryData.getName();
        InputStream inputStream = entryData.openInputStream();
        if (!this.isTypeSignatureInUse(inputStream, this.dbTableAnnotationBytes)) {
            return;
        }
        try {
            beanClass = this.loadClass(entryName);
        }
        catch (ClassNotFoundException cnfex) {
            throw new DbOomException("Unable to load class: " + entryName, cnfex);
        }
        DbTable dbTable = beanClass.getAnnotation(DbTable.class);
        if (dbTable == null) {
            return;
        }
        if (this.registerAsEntities) {
            this.dbOomManager.registerEntity(beanClass);
        } else {
            this.dbOomManager.registerType(beanClass);
        }
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtil.loadClass((String)className, ((Object)((Object)this)).getClass());
    }
}

