/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.util.ArrayList;
import jodd.mutable.MutableInteger;
import jodd.proxetta.asm.ProxettaAsmUtil;

public class InvokeInfo {
    private final String owner;
    private final String className;
    private final String classShortName;
    private final String methodName;
    private final String description;
    private final String returnType;
    private final String signature;
    private final String[] arguments;

    public InvokeInfo(String owner, String methodName, String description) {
        this.owner = owner;
        this.className = owner.replace('/', '.');
        this.methodName = methodName;
        this.description = description;
        int ndx = this.className.lastIndexOf(46);
        this.classShortName = ndx == -1 ? this.className : this.className.substring(ndx + 1);
        ArrayList<String> args = new ArrayList<String>();
        MutableInteger from = new MutableInteger(1);
        if (description.length() != 0) {
            while (description.charAt(from.value) != ')') {
                String a = ProxettaAsmUtil.typedescToSignature(description, from);
                args.add(a);
            }
        }
        this.arguments = new String[args.size()];
        args.toArray(this.arguments);
        ++from.value;
        this.returnType = description.length() > 0 ? ProxettaAsmUtil.typedescToSignature(description, from) : this.className;
        StringBuilder s = new StringBuilder();
        s.append(this.returnType).append(' ').append(methodName).append('(');
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i != 0) {
                s.append(',').append(' ');
            }
            String argument = this.arguments[i];
            s.append(argument);
        }
        s.append(')');
        this.signature = s.toString();
    }

    public String getOwner() {
        return this.owner;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassShortName() {
        return this.classShortName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getSignature() {
        return this.signature;
    }

    public int getArgumentsCount() {
        return this.arguments.length;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String toString() {
        return "InvokeInfo: " + this.signature;
    }
}

