/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx.worker;

import jodd.jtx.JtxTransaction;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.JtxTransactionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeanTransactionWorker {
    private static final Logger log = LoggerFactory.getLogger(LeanTransactionWorker.class);
    protected final JtxTransactionManager txManager;

    public LeanTransactionWorker(JtxTransactionManager txManager) {
        this.txManager = txManager;
    }

    public JtxTransactionManager getTransactionManager() {
        return this.txManager;
    }

    public JtxTransaction getCurrentTransaction() {
        return this.txManager.getTransaction();
    }

    public JtxTransaction maybeRequestTransaction(JtxTransactionMode txMode, Object context) {
        JtxTransaction requestedTx;
        if (txMode == null) {
            return null;
        }
        JtxTransaction currentTx = this.txManager.getTransaction();
        if (currentTx == (requestedTx = this.txManager.requestTransaction(txMode, context))) {
            return null;
        }
        return requestedTx;
    }

    public boolean maybeCommitTransaction(JtxTransaction tx) {
        if (tx == null) {
            return false;
        }
        log.info("commit tx");
        tx.commit();
        return true;
    }

    public boolean markOrRollbackTransaction(JtxTransaction tx, Throwable cause) {
        log.error("rollback tx", cause);
        if (tx == null) {
            tx = this.getCurrentTransaction();
            if (tx == null) {
                return false;
            }
            tx.setRollbackOnly(cause);
            return false;
        }
        tx.rollback();
        return true;
    }
}

