/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.lang.reflect.Modifier;
import java.util.Properties;
import javax.servlet.ServletContext;
import jodd.madvoc.component.ActionMethodParser;
import jodd.madvoc.component.ActionPathMapper;
import jodd.madvoc.component.ActionPathRewriter;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.ContextInjector;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.component.ResultMapper;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.config.MadvocConfigurator;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteUtil;
import jodd.props.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebApplication {
    private static Logger log;
    public static final String MADVOC_CONTAINER_NAME = "madpc";
    protected PetiteContainer madpc;

    public WebApplication() {
    }

    public WebApplication(boolean init) {
        if (init) {
            this.initWebApplication();
        }
    }

    protected void initWebApplication() {
        log = LoggerFactory.getLogger(WebApplication.class);
        log.debug("Initializing Madvoc web application");
        this.madpc = new PetiteContainer();
        this.madpc.addSelf(MADVOC_CONTAINER_NAME);
    }

    private String resolveBaseComponentName(Class component) {
        Class superClass;
        Class lastComponent = component;
        while (!(superClass = component.getSuperclass()).equals(Object.class)) {
            component = superClass;
            if (Modifier.isAbstract(component.getModifiers())) continue;
            lastComponent = component;
        }
        return PetiteUtil.resolveBeanName(lastComponent);
    }

    public final void registerComponent(Class component) {
        String name = this.resolveBaseComponentName(component);
        this.registerComponent(name, component);
    }

    public final void registerComponent(String name, Class component) {
        if (log.isDebugEnabled()) {
            log.debug("Registering component '{}' of type {}", (Object)name, (Object)component.getName());
        }
        this.madpc.removeBean(name);
        this.madpc.registerBean(name, component);
    }

    public final void registerComponent(Object componentInstance) {
        Class<?> component = componentInstance.getClass();
        String name = this.resolveBaseComponentName(component);
        this.registerComponent(name, componentInstance);
    }

    public final void registerComponent(String name, Object componentInstance) {
        if (log.isDebugEnabled()) {
            log.debug("Registering component '{}' instace of {}", (Object)name, (Object)componentInstance.getClass().getName());
        }
        this.madpc.removeBean(name);
        this.madpc.addBean(name, componentInstance);
    }

    public <T> T getComponent(Class<T> component) {
        String name = this.resolveBaseComponentName(component);
        return (T)this.madpc.getBean(name);
    }

    public Object getComponent(String componentName) {
        return this.madpc.getBean(componentName);
    }

    public void registerMadvocComponents() {
        log.debug("Registering Madvoc components");
        this.registerComponent(ActionMethodParser.class);
        this.registerComponent(ActionPathMapper.class);
        this.registerComponent(ActionPathRewriter.class);
        this.registerComponent(ActionsManager.class);
        this.registerComponent(InterceptorsManager.class);
        this.registerComponent(MadvocConfig.class);
        this.registerComponent(MadvocController.class);
        this.registerComponent(ResultsManager.class);
        this.registerComponent(ResultMapper.class);
        this.registerComponent(ContextInjector.class);
    }

    protected void defineParams(Properties properties) {
        log.debug("Defining Madvoc parameters");
        this.madpc.defineParameters(properties);
    }

    protected void defineParams(Props props) {
        log.debug("Defining Madvoc parameters");
        this.madpc.defineParameters(props);
    }

    protected void init(MadvocConfig madvocConfig, ServletContext context) {
        log.debug("Initializing Madvoc");
    }

    protected void initActions(ActionsManager actionManager) {
        log.debug("Initializing Madvoc actions");
    }

    protected void initResults(ResultsManager actionManager) {
        log.debug("Initializing Madvoc results");
    }

    protected void destroy(MadvocConfig madvocConfig) {
        log.debug("Destroying Madvoc");
    }

    public void configure(MadvocConfigurator configurator) {
        log.debug("Configuring Madvoc");
        this.madpc.wire(configurator);
        configurator.configure();
    }
}

