/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.In;
import jodd.madvoc.meta.Out;
import jodd.madvoc.result.ActionResult;

public class ListMadvocConfig {
    @In(scope=ScopeType.CONTEXT)
    protected ActionsManager actionsManager;
    @In(scope=ScopeType.CONTEXT)
    protected InterceptorsManager interceptorsManager;
    @In(scope=ScopeType.CONTEXT)
    protected ResultsManager resultsManager;
    @Out
    protected List<ActionConfig> actions;
    @Out
    protected List<ActionResult> results;
    @Out
    protected List<ActionInterceptor> interceptors;

    protected void collectActionInterceptors() {
        Collection<ActionInterceptor> interceptorValues = this.interceptorsManager.getAllActionInterceptors().values();
        this.interceptors = new ArrayList<ActionInterceptor>();
        this.interceptors.addAll(interceptorValues);
        Collections.sort(this.interceptors, new Comparator<ActionInterceptor>(){

            @Override
            public int compare(ActionInterceptor a1, ActionInterceptor a2) {
                return a1.getClass().getSimpleName().compareTo(a2.getClass().getSimpleName());
            }
        });
    }

    protected void collectActionResults() {
        Collection<ActionResult> resultsValues = this.resultsManager.getAllActionResults().values();
        this.results = new ArrayList<ActionResult>();
        this.results.addAll(resultsValues);
        Collections.sort(this.results, new Comparator<ActionResult>(){

            @Override
            public int compare(ActionResult a1, ActionResult a2) {
                return a1.getType().compareTo(a2.getType());
            }
        });
    }

    protected void collectActionConfigs() {
        Collection<ActionConfig> values = this.actionsManager.getAllActionConfigurations().values();
        this.actions = new ArrayList<ActionConfig>(values.size());
        this.actions.addAll(values);
        Collections.sort(this.actions, new Comparator<ActionConfig>(){

            @Override
            public int compare(ActionConfig a1, ActionConfig a2) {
                return a1.actionPath.compareTo(a2.actionPath);
            }
        });
    }

    protected String toSystemOut() {
        System.out.println("ACTIONS");
        System.out.println("-------");
        for (ActionConfig ac : this.actions) {
            if (ac.isInitialized()) {
                System.out.print("[x] ");
            } else {
                System.out.print("[ ] ");
            }
            System.out.println(ac.actionPath + "  ->  " + ac.getActionString());
        }
        System.out.println("\nINTERCEPTORS");
        System.out.println("------------");
        for (ActionInterceptor ai : this.interceptors) {
            if (ai.isInitialized()) {
                System.out.print("[x] ");
            } else {
                System.out.print("[ ] ");
            }
            System.out.println(ai.getClass().getName());
        }
        System.out.println("\nRESULTS");
        System.out.println("-------");
        for (ActionResult ar : this.results) {
            if (ar.isInitialized()) {
                System.out.print("[x] ");
            } else {
                System.out.print("[ ] ");
            }
            System.out.println(ar.getType() + "  " + ar.getClass().getName());
        }
        return "none:";
    }
}

