/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.lang.reflect.Method;
import jodd.madvoc.ActionConfig;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.Action;
import jodd.madvoc.meta.InterceptedBy;
import jodd.madvoc.meta.MadvocAction;
import jodd.petite.meta.PetiteInject;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMethodParser {
    protected static final String MACRO_PACKAGE = "${package}";
    protected static final String MACRO_CLASS = "${class}";
    protected static final String MACRO_METHOD = "${method}";
    protected static final String MACRO_EXTENSION = "${ext}";
    @PetiteInject
    protected MadvocConfig madvocConfig;

    public ActionConfig parse(Class<?> actionClass, Method actionMethod) {
        return this.parse(actionClass, actionMethod, null);
    }

    public ActionConfig parse(Class<?> actionClass, Method actionMethod, String actionPath) {
        Class<? extends ActionInterceptor>[] interceptorClasses;
        Class<?> superClass = null;
        if (actionClass.getAnnotation(MadvocAction.class) == null && ((superClass = actionClass.getSuperclass()) == Object.class || superClass.getAnnotation(MadvocAction.class) == null)) {
            superClass = null;
        }
        if ((interceptorClasses = this.readMethodInterceptors(actionMethod)) == null) {
            interceptorClasses = this.readClassInterceptors(superClass != null ? superClass : actionClass);
        }
        if (actionPath != null) {
            return this.createActionConfig(actionClass, actionMethod, interceptorClasses, actionPath);
        }
        String packageActionPath = this.readPackageActionPath(superClass != null ? superClass : actionClass);
        String classActionPath = this.readClassActionPath(superClass != null ? superClass : actionClass);
        if (classActionPath == null) {
            return null;
        }
        String methodActionPath = this.readMethodActionPath(actionMethod);
        String extension = this.readMethodExtension(actionMethod);
        String alias = this.readMethodAlias(actionMethod);
        String httpMethod = this.readMethodHttpMethod(actionMethod);
        if (methodActionPath != null) {
            methodActionPath = StringUtil.replace((String)methodActionPath, (String)MACRO_EXTENSION, (String)extension);
            for (String path : this.madvocConfig.getDefaultActionMethodNames()) {
                if (!methodActionPath.equals(path)) continue;
                methodActionPath = null;
                break;
            }
        }
        actionPath = this.buildActionPath(packageActionPath, classActionPath, methodActionPath, extension, httpMethod);
        if (alias != null) {
            String aliasPath = StringUtil.cutFromIndexOf((String)actionPath, (String)"#");
            this.madvocConfig.registerResultAlias(alias, aliasPath);
        }
        return this.createActionConfig(actionClass, actionMethod, interceptorClasses, actionPath);
    }

    protected String buildActionPath(String packageActionPath, String classActionPath, String methodActionPath, String extension, String httpMethod) {
        String pathSeparator = "/";
        String actionPath = classActionPath;
        if (methodActionPath != null) {
            if (methodActionPath.startsWith(pathSeparator)) {
                return methodActionPath;
            }
            if (extension != null) {
                methodActionPath = methodActionPath + '.' + extension;
            }
            actionPath = actionPath + "." + methodActionPath;
        } else if (extension != null) {
            actionPath = actionPath + '.' + extension;
        }
        if (actionPath.startsWith(pathSeparator)) {
            return actionPath;
        }
        actionPath = packageActionPath != null ? packageActionPath + actionPath : pathSeparator + actionPath;
        if (httpMethod != null) {
            actionPath = actionPath + "#" + httpMethod;
        }
        return actionPath;
    }

    protected Class<? extends ActionInterceptor>[] readClassInterceptors(Class actionClass) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionClass.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected Class<? extends ActionInterceptor>[] readMethodInterceptors(Method actionMethod) {
        Class<? extends ActionInterceptor>[] result = null;
        InterceptedBy interceptedBy = actionMethod.getAnnotation(InterceptedBy.class);
        if (interceptedBy != null && (result = interceptedBy.value()).length == 0) {
            result = null;
        }
        return result;
    }

    protected String readPackageActionPath(Class actionClass) {
        String packagePath;
        String packageActionPath;
        String packageRoot = this.madvocConfig.getRootPackage();
        if (packageRoot == null) {
            return null;
        }
        MadvocAction madvocActionAnnotation = actionClass.getPackage().getAnnotation(MadvocAction.class);
        String string = packageActionPath = madvocActionAnnotation != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty((String)packageActionPath)) {
            packageActionPath = null;
        }
        packagePath = (packagePath = actionClass.getPackage().getName()).length() > packageRoot.length() ? StringUtil.cutPreffix((String)packagePath, (String)(packageRoot + '.')) : StringUtil.cutPreffix((String)packagePath, (String)packageRoot);
        packagePath = packagePath.replace('.', '/');
        packageActionPath = packageActionPath == null ? packagePath : StringUtil.replace((String)packageActionPath, (String)MACRO_PACKAGE, (String)packagePath);
        return StringUtil.surround((String)packageActionPath, (String)"/");
    }

    protected String readClassActionPath(Class actionClass) {
        String classActionPath;
        MadvocAction madvocActionAnnotation = actionClass.getAnnotation(MadvocAction.class);
        String string = classActionPath = madvocActionAnnotation != null ? madvocActionAnnotation.value().trim() : null;
        if (StringUtil.isEmpty((String)classActionPath)) {
            classActionPath = null;
        }
        String name = this.convertClassNameToActionName(actionClass.getSimpleName());
        classActionPath = classActionPath == null ? name : StringUtil.replace((String)classActionPath, (String)MACRO_CLASS, (String)name);
        return classActionPath;
    }

    protected String convertClassNameToActionName(String name) {
        int ndx;
        name = StringUtil.uncapitalize((String)name);
        for (ndx = name.length() - 1; ndx >= 0 && !Character.isUpperCase(name.charAt(ndx)); --ndx) {
        }
        if (ndx >= 0) {
            name = name.substring(0, ndx);
        }
        return name;
    }

    protected String readMethodActionPath(Method actionMethod) {
        String methodActionPath;
        Action methodAnnotation = actionMethod.getAnnotation(Action.class);
        String string = methodActionPath = methodAnnotation != null ? methodAnnotation.value().trim() : null;
        if (StringUtil.isEmpty((String)methodActionPath)) {
            methodActionPath = null;
        }
        String methodName = actionMethod.getName();
        methodActionPath = methodActionPath == null ? methodName : StringUtil.replace((String)methodActionPath, (String)MACRO_METHOD, (String)methodName);
        if (methodAnnotation != null && methodAnnotation.notInPath()) {
            methodActionPath = null;
        }
        return methodActionPath;
    }

    protected String readMethodExtension(Method actionMethod) {
        String extension = this.madvocConfig.getDefaultExtension();
        Action methodAnnotation = actionMethod.getAnnotation(Action.class);
        if (methodAnnotation != null) {
            String annExtension = methodAnnotation.extension().trim();
            if (annExtension.equals("#")) {
                extension = null;
            } else if (annExtension.length() != 0) {
                extension = StringUtil.replace((String)annExtension, (String)MACRO_EXTENSION, (String)extension);
            }
        }
        return extension;
    }

    protected String readMethodAlias(Method actionMethod) {
        String alias = null;
        Action methodAnnotation = actionMethod.getAnnotation(Action.class);
        if (methodAnnotation != null && (alias = methodAnnotation.alias().trim()).length() == 0) {
            alias = null;
        }
        return alias;
    }

    private String readMethodHttpMethod(Method actionMethod) {
        String method = null;
        Action methodAnnotation = actionMethod.getAnnotation(Action.class);
        if (methodAnnotation != null && (method = methodAnnotation.method().trim()).length() == 0) {
            method = null;
        }
        return method;
    }

    protected ActionConfig createActionConfig(Class actionClass, Method actionMethod, Class<? extends ActionInterceptor>[] interceptorClasses, String actionPath) {
        return new ActionConfig(actionClass, actionMethod, interceptorClasses, actionPath);
    }
}

