/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jodd.madvoc.MadvocException;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.interceptor.ActionInterceptorStack;
import jodd.madvoc.interceptor.DefaultWebAppInterceptors;
import jodd.petite.meta.PetiteInject;
import jodd.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorsManager {
    @PetiteInject
    protected MadvocConfig madvocConfig;
    protected Map<Class<? extends ActionInterceptor>, ActionInterceptor> interceptors = new HashMap<Class<? extends ActionInterceptor>, ActionInterceptor>();

    public Map<Class<? extends ActionInterceptor>, ActionInterceptor> getAllActionInterceptors() {
        return this.interceptors;
    }

    public ActionInterceptor lookup(Class<? extends ActionInterceptor> interceptorClass) {
        return this.interceptors.get(interceptorClass);
    }

    public ActionInterceptor resolve(Class<? extends ActionInterceptor> interceptorClass) {
        ActionInterceptor interceptor = this.lookup(interceptorClass);
        if (interceptor == null) {
            interceptor = this.createInterceptor(interceptorClass);
            this.interceptors.put(interceptorClass, interceptor);
        }
        return interceptor;
    }

    public ActionInterceptor[] resolveAll(Class<? extends ActionInterceptor> ... interceptorClasses) {
        if (interceptorClasses == null) {
            return null;
        }
        interceptorClasses = this.expand(interceptorClasses);
        ActionInterceptor[] result = new ActionInterceptor[interceptorClasses.length];
        for (int i = 0; i < interceptorClasses.length; ++i) {
            result[i] = this.resolve(interceptorClasses[i]);
        }
        return result;
    }

    protected Class<? extends ActionInterceptor>[] expand(Class<? extends ActionInterceptor>[] actionInterceptors) {
        if (actionInterceptors == null) {
            return null;
        }
        ArrayList<Class<? extends ActionInterceptor>> list = new ArrayList<Class<? extends ActionInterceptor>>(actionInterceptors.length);
        list.addAll(Arrays.asList(actionInterceptors));
        int i = 0;
        while (i < list.size()) {
            Class interceptorClass = (Class)list.get(i);
            if (interceptorClass == null) continue;
            if (interceptorClass.equals(DefaultWebAppInterceptors.class)) {
                list.remove(i);
                Class<? extends ActionInterceptor>[] defaultInterceptors = this.madvocConfig.getDefaultInterceptors();
                if (defaultInterceptors != null) {
                    for (Class<? extends ActionInterceptor> defaultInterceptor : defaultInterceptors) {
                        if (defaultInterceptor.equals(DefaultWebAppInterceptors.class)) {
                            throw new MadvocException("Default interceptor list is self-contained (cyclic dependency)");
                        }
                        list.add(i, defaultInterceptor);
                    }
                }
                --i;
                continue;
            }
            if (ReflectUtil.isSubclass((Class)interceptorClass, ActionInterceptorStack.class)) {
                ActionInterceptorStack stack = (ActionInterceptorStack)this.resolve(interceptorClass);
                list.remove(i);
                Class<? extends ActionInterceptor>[] stackInterceptors = stack.getInterceptors();
                if (stackInterceptors != null) {
                    list.addAll(i, Arrays.asList(stackInterceptors));
                }
                --i;
            }
            ++i;
        }
        return list.toArray(new Class[list.size()]);
    }

    protected ActionInterceptor createInterceptor(Class<? extends ActionInterceptor> interceptorClass) {
        try {
            return interceptorClass.newInstance();
        }
        catch (InstantiationException iex) {
            throw new MadvocException("Unable to create Madvoc interceptor '" + interceptorClass + "'.", iex);
        }
        catch (IllegalAccessException iaex) {
            throw new MadvocException("Not enough rights to create Madvoc action interceptor '" + interceptorClass + "'.", iaex);
        }
    }
}

