/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import jodd.petite.BeanDefinition;
import jodd.petite.InitMethodPoint;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteException;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.WiringMode;
import jodd.petite.manager.PetiteManager;
import jodd.petite.scope.Scope;
import jodd.props.Props;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PetiteContainerRegistry {
    protected final PetiteManager petiteManager;
    protected final PetiteConfig petiteConfig;

    protected PetiteContainerRegistry(PetiteManager petiteManager, PetiteConfig petiteConfig) {
        this.petiteManager = petiteManager;
        this.petiteConfig = petiteConfig;
    }

    public PetiteManager getManager() {
        return this.petiteManager;
    }

    public PetiteConfig getConfig() {
        return this.petiteConfig;
    }

    public void registerBean(Class type) {
        this.registerPetiteBean(null, type, null, null);
    }

    public void registerBean(Class type, Class<? extends Scope> scopeType) {
        this.registerPetiteBean(null, type, scopeType, null);
    }

    public void registerBean(Class type, Class<? extends Scope> scopeType, WiringMode wiringMode) {
        this.registerPetiteBean(null, type, scopeType, wiringMode);
    }

    public void registerBean(String name, Class type) {
        this.registerPetiteBean(name, type, null, null);
    }

    public void registerBean(String name, Class type, Class<? extends Scope> scopeType) {
        this.registerPetiteBean(name, type, scopeType, null);
    }

    public void registerBean(String name, Class type, Class<? extends Scope> scopeType, WiringMode wiringMode) {
        this.registerPetiteBean(name, type, scopeType, wiringMode);
    }

    protected BeanDefinition registerPetiteBean(String name, Class type, Class<? extends Scope> scopeType, WiringMode wiringMode) {
        return this.petiteManager.registerBean(name, type, scopeType, wiringMode, this.petiteConfig);
    }

    public BeanDefinition lookupBeanDefinition(String name) {
        return this.petiteManager.lookupBeanDefinition(name);
    }

    public BeanDefinition lookupExistingBeanDefinition(String name) {
        BeanDefinition beanDefinition = this.lookupBeanDefinition(name);
        if (beanDefinition == null) {
            throw new PetiteException("Bean: '" + name + "' not registered.");
        }
        return beanDefinition;
    }

    public boolean isBeanNameRegistered(String name) {
        return this.lookupBeanDefinition(name) != null;
    }

    public void defineBean(Class type) {
        this.definePetiteBean(null, type, null, null);
    }

    public void defineBean(Class type, Class<? extends Scope> scopeType) {
        this.definePetiteBean(null, type, scopeType, null);
    }

    public void defineBean(Class type, Class<? extends Scope> scopeType, WiringMode wiringMode) {
        this.definePetiteBean(null, type, scopeType, wiringMode);
    }

    public void defineBean(String name, Class type) {
        this.definePetiteBean(name, type, null, null);
    }

    public void defineBean(String name, Class type, Class<? extends Scope> scopeType) {
        this.definePetiteBean(name, type, scopeType, null);
    }

    public void defineBean(String name, Class type, Class<? extends Scope> scopeType, WiringMode wiringMode) {
        this.definePetiteBean(name, type, scopeType, wiringMode);
    }

    protected void definePetiteBean(String name, Class type, Class<? extends Scope> scopeType, WiringMode wiringMode) {
        BeanDefinition def = this.registerPetiteBean(name, type, scopeType, wiringMode);
        def.ctor = this.petiteManager.resolveCtorInjectionPoint(type);
        def.properties = PropertyInjectionPoint.EMPTY;
        def.methods = MethodInjectionPoint.EMPTY;
        def.initMethods = InitMethodPoint.EMPTY;
    }

    public void registerCtorInjectionPoint(String beanName) {
        this.registerPetiteCtorInjectionPoint(beanName, null, null);
    }

    public void registerCtorInjectionPoint(String beanName, Class[] paramTypes) {
        this.registerPetiteCtorInjectionPoint(beanName, paramTypes, null);
    }

    public void registerCtorInjectionPoint(String beanName, String ... references) {
        this.registerPetiteCtorInjectionPoint(beanName, null, references);
    }

    public void registerCtorInjectionPoint(String beanName, Class[] paramTypes, String ... references) {
        this.registerPetiteCtorInjectionPoint(beanName, paramTypes, references);
    }

    protected void registerPetiteCtorInjectionPoint(String beanName, Class[] paramTypes, String[] references) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        beanDefinition.ctor = this.petiteManager.defineCtorInjectionPoint(beanDefinition.type, paramTypes, references);
    }

    public void registerPropertyInjectionPoint(String beanName, String property) {
        this.registerPetitePropertyInjectionPoint(beanName, property, null);
    }

    public void registerPropertyInjectionPoint(String beanName, String property, String reference) {
        this.registerPetitePropertyInjectionPoint(beanName, property, reference);
    }

    protected void registerPetitePropertyInjectionPoint(String beanName, String property, String reference) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        PropertyInjectionPoint pip = this.petiteManager.definePropertyInjectionPoint(beanDefinition.type, property, reference);
        beanDefinition.addPropertyInjectionPoint(pip);
    }

    public void registerMethodInjectionPoint(String beanName, String methodName) {
        this.registerPetiteMethodInjectionPoint(beanName, methodName, null, null);
    }

    public void registerMethodInjectionPoint(String beanName, String methodName, String ... references) {
        this.registerPetiteMethodInjectionPoint(beanName, methodName, null, references);
    }

    public void registerMethodInjectionPoint(String beanName, String methodName, Class[] arguments) {
        this.registerPetiteMethodInjectionPoint(beanName, methodName, arguments, null);
    }

    public void registerMethodInjectionPoint(String beanName, String methodName, Class[] arguments, String[] references) {
        this.registerPetiteMethodInjectionPoint(beanName, methodName, arguments, references);
    }

    protected void registerPetiteMethodInjectionPoint(String beanName, String methodName, Class[] arguments, String[] references) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        MethodInjectionPoint mip = this.petiteManager.defineMethodInjectionPoint(beanDefinition.type, methodName, arguments, references);
        beanDefinition.addMethodInjectionPoint(mip);
    }

    public void registerInitMethods(String beanName, String ... methodNames) {
        this.registerPetiteInitMethods(beanName, null, methodNames);
    }

    public void registerInitMethods(String beanName, String[] beforeMethodNames, String[] afterMethodNames) {
        this.registerPetiteInitMethods(beanName, beforeMethodNames, afterMethodNames);
    }

    protected void registerPetiteInitMethods(String beanName, String[] beforeMethodNames, String[] afterMethodNames) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        InitMethodPoint[] methods = this.petiteManager.defineInitMethods(beanDefinition.type, beforeMethodNames, afterMethodNames);
        beanDefinition.addInitMethodPoints(methods);
    }

    public void removeBean(Class type) {
        HashSet<String> beanNames = new HashSet<String>();
        Iterator<BeanDefinition> it = this.beansIterator();
        while (it.hasNext()) {
            BeanDefinition def = it.next();
            if (!def.type.equals(type)) continue;
            beanNames.add(def.name);
        }
        for (String beanName : beanNames) {
            this.removeBean(beanName);
        }
    }

    public void removeBean(String name) {
        this.petiteManager.removeBean(name);
    }

    public void defineParameter(String name, Object value) {
        this.petiteManager.defineParameter(name, value);
    }

    public void defineParameters(Map<Object, Object> properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.defineParameter(entry.getKey().toString(), entry.getValue());
        }
    }

    public void defineParameters(Props props) {
        this.defineParameters(props.extractProperties());
    }

    public int getTotalBeans() {
        return this.petiteManager.getTotalBeans();
    }

    public int getTotalScopes() {
        return this.petiteManager.getTotalScopes();
    }

    public Iterator<BeanDefinition> beansIterator() {
        return this.petiteManager.beansIterator();
    }
}

