/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import jodd.petite.WiringMode;
import jodd.petite.meta.PetiteBean;
import jodd.petite.scope.DefaultScope;
import jodd.petite.scope.Scope;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetiteUtil {
    private static final String NAMES_DELIMITER = ", ";

    public static String[] resolveParamReferences(String refValue, Class<?>[] paramTypes) {
        String[] refNames = (refValue = refValue.trim()).length() == 0 ? PetiteUtil.resolveParamReferences(paramTypes) : StringUtil.splitc((String)refValue, (String)NAMES_DELIMITER);
        return refNames;
    }

    public static String[] resolveParamReferences(Class<?>[] paramTypes) {
        String[] refNames = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            refNames[i] = StringUtil.uncapitalize((String)paramTypes[i].getSimpleName());
        }
        return refNames;
    }

    public static WiringMode resolveBeanWiringMode(Class type) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        return petiteBean != null ? petiteBean.wiring() : WiringMode.DEFAULT;
    }

    public static Class<? extends Scope> resolveBeanScopeType(Class type) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        return petiteBean != null ? petiteBean.scope() : DefaultScope.class;
    }

    public static String resolveBeanName(Class type) {
        PetiteBean petiteBean = type.getAnnotation(PetiteBean.class);
        String name = null;
        if (petiteBean != null) {
            name = petiteBean.value().trim();
        }
        if (name == null || name.length() == 0) {
            name = StringUtil.uncapitalize((String)type.getSimpleName());
        }
        return name;
    }
}

