/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.config;

import java.io.InputStream;
import java.net.URL;
import jodd.io.findfile.FindClass;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.config.PetiteConfigurator;
import jodd.petite.meta.PetiteBean;
import jodd.util.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomagicPetiteConfigurator
extends FindClass
implements PetiteConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicPetiteConfigurator.class);
    protected final byte[] petiteBeanAnnotationBytes = this.getTypeSignatureBytes(PetiteBean.class);
    protected PetiteContainer container;
    protected long elapsed;

    public long getElapsed() {
        return this.elapsed;
    }

    public void configure(PetiteContainer petiteContainer, URL[] classpath) {
        this.container = petiteContainer;
        this.elapsed = System.currentTimeMillis();
        try {
            this.scanUrls(classpath);
        }
        catch (Exception ex) {
            throw new PetiteException("Unable to scan classpath.", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        log.info("Petite configured in " + this.elapsed + " ms. Total beans: " + petiteContainer.getManager().getTotalBeans());
    }

    public void configure(PetiteContainer petiteContainer) {
        this.configure(petiteContainer, ClassLoaderUtil.getFullClassPath(AutomagicPetiteConfigurator.class));
    }

    protected void onEntry(FindClass.EntryData entryData) {
        Class beanClass;
        String entryName = entryData.getName();
        InputStream inputStream = entryData.openInputStream();
        if (!this.isTypeSignatureInUse(inputStream, this.petiteBeanAnnotationBytes)) {
            return;
        }
        try {
            beanClass = this.loadClass(entryName);
        }
        catch (ClassNotFoundException cnfex) {
            throw new PetiteException("Unable to load class: " + cnfex, cnfex);
        }
        PetiteBean petiteBean = beanClass.getAnnotation(PetiteBean.class);
        if (petiteBean == null) {
            return;
        }
        this.container.registerBean(beanClass);
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        return ClassLoaderUtil.loadClass((String)className, this.getClass());
    }
}

