/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.manager;

import java.util.HashMap;
import java.util.Map;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteException;
import jodd.petite.WiringMode;
import jodd.petite.scope.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanManager {
    protected final Map<String, BeanDefinition> beans = new HashMap<String, BeanDefinition>();
    protected final Map<Class<? extends Scope>, Scope> scopes = new HashMap<Class<? extends Scope>, Scope>();

    protected Scope resolveScope(Class<? extends Scope> scopeType) {
        Scope scope = this.scopes.get(scopeType);
        if (scope == null) {
            try {
                scope = scopeType.newInstance();
                this.registerScope(scopeType, scope);
                this.scopes.put(scopeType, scope);
            }
            catch (Exception ex) {
                throw new PetiteException("Unable to create Petite scope: '" + scopeType.getName(), ex);
            }
        }
        return scope;
    }

    public void registerScope(Class<? extends Scope> scopeType, Scope scope) {
        this.scopes.put(scopeType, scope);
    }

    public BeanDefinition register(String name, Class type, Class<? extends Scope> scopeType, WiringMode wiringMode) {
        if (type != null && type.isInterface()) {
            throw new PetiteException("Unable to register interface '" + type.getName() + "'.");
        }
        Scope scope = this.resolveScope(scopeType);
        BeanDefinition beanDefinition = new BeanDefinition(name, type, scope, wiringMode);
        this.beans.put(name, beanDefinition);
        return beanDefinition;
    }
}

