/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.manager;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.meta.PetiteInject;

public class PropertyResolver {
    protected final Map<Class, PropertyInjectionPoint[]> properties = new HashMap<Class, PropertyInjectionPoint[]>();

    public PropertyInjectionPoint[] resolve(Class type) {
        Field[] allFields;
        PropertyInjectionPoint[] fields = this.properties.get(type);
        if (fields != null) {
            return fields;
        }
        ClassDescriptor cd = ClassIntrospector.lookup((Class)type);
        ArrayList<PropertyInjectionPoint> list = new ArrayList<PropertyInjectionPoint>();
        for (Field field : allFields = cd.getAllFields(true)) {
            String refName;
            boolean hasAnnotation;
            PetiteInject ref = field.getAnnotation(PetiteInject.class);
            if (ref == null) {
                hasAnnotation = false;
                refName = field.getName();
            } else {
                hasAnnotation = true;
                refName = ref.value().trim();
                if (refName.length() == 0) {
                    refName = field.getName();
                }
            }
            list.add(new PropertyInjectionPoint(field, refName, hasAnnotation));
        }
        fields = list.isEmpty() ? PropertyInjectionPoint.EMPTY : list.toArray(new PropertyInjectionPoint[list.size()]);
        this.properties.put(type, fields);
        return fields;
    }
}

