/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta;

import java.io.InputStream;
import jodd.JoddDefault;
import jodd.proxetta.InvokeAspect;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.ProxyAspect;
import jodd.proxetta.asm.ClassProcessor;
import jodd.proxetta.impl.InvokeProxetta;
import jodd.proxetta.impl.ProxyProxetta;
import jodd.util.ClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Proxetta {
    protected boolean forced;
    protected ClassLoader classLoader;
    protected boolean variableClassName;
    protected String classNameSuffix;

    public static Proxetta withAspects(ProxyAspect ... aspects) {
        return new ProxyProxetta(aspects);
    }

    public static Proxetta withAspects(InvokeAspect ... aspects) {
        return new InvokeProxetta(aspects);
    }

    public Proxetta forced(boolean forced) {
        this.forced = forced;
        return this;
    }

    public Proxetta loadsWith(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Proxetta variableClassName() {
        this.variableClassName = true;
        return this;
    }

    public Proxetta constantClassName() {
        this.variableClassName = false;
        return this;
    }

    public Proxetta useClassNameSuffix(String suffix) {
        this.classNameSuffix = suffix;
        return this;
    }

    public Proxetta dontUseClassNameSuffix() {
        this.classNameSuffix = null;
        return this;
    }

    protected abstract ClassProcessor createClassProcessor();

    protected ClassProcessor prepareClassProcessor() {
        ClassProcessor cp = this.createClassProcessor();
        cp.setUseVariableClassName(this.variableClassName);
        cp.setClassNameSuffix(this.classNameSuffix);
        return cp;
    }

    public byte[] createProxy(Class target) {
        return this.createProxy(target, null);
    }

    public byte[] createProxy(Class target, String proxyClassName) {
        return this.createProxy(this.prepareClassProcessor().accept(target, proxyClassName));
    }

    public byte[] createProxy(String targetName) {
        return this.createProxy(targetName, null);
    }

    public byte[] createProxy(String targetName, String proxyClassName) {
        return this.createProxy(this.prepareClassProcessor().accept(targetName, proxyClassName));
    }

    public byte[] createProxy(InputStream in) {
        return this.createProxy(in, null);
    }

    public byte[] createProxy(InputStream in, String proxyClassName) {
        return this.createProxy(this.prepareClassProcessor().accept(in, proxyClassName));
    }

    protected byte[] createProxy(ClassProcessor cp) {
        byte[] result = cp.toByteArray();
        if (!this.forced && !cp.isProxyApplied()) {
            return null;
        }
        return result;
    }

    public Class defineProxy(Class target) {
        return this.defineProxy(target, null);
    }

    public Class defineProxy(Class target, String proxyClassName) {
        ClassProcessor cp = this.prepareClassProcessor();
        cp.accept(target, proxyClassName);
        if (!this.forced && !cp.isProxyApplied()) {
            return target;
        }
        try {
            if (this.classLoader == null) {
                ClassLoader cl = target.getClassLoader();
                if (cl == null) {
                    cl = JoddDefault.classLoader;
                }
                return ClassLoaderUtil.defineClass((String)cp.getProxyClassName(), (byte[])cp.toByteArray(), (ClassLoader)cl);
            }
            return ClassLoaderUtil.defineClass((String)cp.getProxyClassName(), (byte[])cp.toByteArray(), (ClassLoader)this.classLoader);
        }
        catch (Exception ex) {
            throw new ProxettaException("Proxy class definition was unsuccessful.", ex);
        }
    }

    public Class defineProxy(String targetName) {
        return this.defineProxy(targetName, null);
    }

    public Class defineProxy(String targetName, String proxyClassName) {
        ClassProcessor cp = this.prepareClassProcessor();
        cp.accept(targetName, proxyClassName);
        if (!this.forced && !cp.isProxyApplied()) {
            try {
                return ClassLoaderUtil.loadClass((String)targetName, Proxetta.class);
            }
            catch (ClassNotFoundException cnfex) {
                throw new ProxettaException(cnfex);
            }
        }
        try {
            if (this.classLoader == null) {
                return ClassLoaderUtil.defineClass((String)cp.getProxyClassName(), (byte[])cp.toByteArray());
            }
            return ClassLoaderUtil.defineClass((String)cp.getProxyClassName(), (byte[])cp.toByteArray(), (ClassLoader)this.classLoader);
        }
        catch (Exception ex) {
            throw new ProxettaException("Proxy class definition was unsuccessful.", ex);
        }
    }

    public <T> T createProxyInstance(Class<T> target) {
        return this.createProxyInstance(target, null);
    }

    public <T> T createProxyInstance(Class<T> target, String proxyClassName) {
        Class c = this.defineProxy(target, proxyClassName);
        try {
            return c.newInstance();
        }
        catch (Exception ex) {
            throw new ProxettaException("Unable to create new proxy instance.", ex);
        }
    }

    public Object createProxyInstance(String targetName) {
        return this.createProxyInstance(targetName, null);
    }

    public Object createProxyInstance(String targetName, String proxyClassName) {
        Class c = this.defineProxy(targetName, proxyClassName);
        try {
            return c.newInstance();
        }
        catch (Exception ex) {
            throw new ProxettaException("Unable to create new proxy instance.", ex);
        }
    }
}

