/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Log;
import jodd.madvoc.WebApplication;
import jodd.madvoc.WebApplicationStarter;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.MadvocController;
import jodd.servlet.DispatcherUtil;
import jodd.typeconverter.Convert;

public class MadvocServletFilter
implements Filter {
    private static Log log;
    public static final String PARAM_MADVOC_WEBAPP = "madvoc.webapp";
    public static final String PARAM_MADVOC_CONFIGURATOR = "madvoc.configurator";
    public static final String PARAM_MADVOC_PARAMS = "madvoc.params";
    protected FilterConfig filterConfig;
    protected WebApplication webapp;
    protected MadvocConfig madvocConfig;
    protected MadvocController madvocController;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        WebApplicationStarter starter = this.createWebApplicationStarter(filterConfig);
        try {
            this.webapp = starter.startNewWebApplication(filterConfig.getServletContext());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServletException("Unable to start Madvoc web application.", (Throwable)ex);
        }
        log = Log.getLogger(MadvocServletFilter.class);
        this.madvocController = starter.getMadvocController();
        this.madvocConfig = starter.getMadvocConfig();
        log.info("Madvoc application started.");
    }

    protected WebApplicationStarter createWebApplicationStarter(FilterConfig filterConfig) {
        WebApplicationStarter starter = new WebApplicationStarter();
        starter.setWebAppClass(filterConfig.getInitParameter(PARAM_MADVOC_WEBAPP));
        starter.setParamsFiles(Convert.toStringArray((Object)filterConfig.getInitParameter(PARAM_MADVOC_PARAMS)));
        starter.setMadvocConfigurator(filterConfig.getInitParameter(PARAM_MADVOC_CONFIGURATOR));
        return starter;
    }

    public void destroy() {
        this.webapp.destroy(this.madvocConfig);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String actionPath = DispatcherUtil.getServletPath((HttpServletRequest)request);
        try {
            actionPath = this.madvocController.invoke(actionPath, request, response);
        }
        catch (Exception ex) {
            log.error("Exception while invoking action path: " + actionPath, ex);
            ex.printStackTrace();
            throw new ServletException((Throwable)ex);
        }
        if (actionPath != null && (actionPath = this.processUnhandledPath(actionPath, req, res)) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected String processUnhandledPath(String actionPath, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        return actionPath;
    }
}

