/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jodd.paramo.MethodParameter;
import jodd.paramo.Paramo;
import jodd.petite.CtorInjectionPoint;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteException;
import jodd.petite.PetiteReference;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.SetInjectionPoint;
import jodd.util.StringUtil;

public class InjectionPointFactory {
    protected final PetiteConfig petiteConfig;

    public InjectionPointFactory(PetiteConfig petiteConfig) {
        this.petiteConfig = petiteConfig;
    }

    public CtorInjectionPoint createCtorInjectionPoint(Constructor constructor, String[][] references) {
        if (references == null || references.length == 0) {
            references = this.methodOrCtorDefaultReferences(constructor, constructor.getParameterTypes());
        }
        if (constructor.getParameterTypes().length != references.length) {
            throw new PetiteException("Different number of constructor parameters and references for: '" + constructor.getName() + "'.");
        }
        this.removeDuplicateNames(references);
        return new CtorInjectionPoint(constructor, references);
    }

    public MethodInjectionPoint createMethodInjectionPoint(Method method, String[][] references) {
        if (references == null || references.length == 0) {
            references = this.methodOrCtorDefaultReferences(method, method.getParameterTypes());
        }
        if (method.getParameterTypes().length != references.length) {
            throw new PetiteException("Different number of method parameters and references for: '" + method.getDeclaringClass().getName() + '#' + method.getName() + "()'.");
        }
        this.removeDuplicateNames(references);
        return new MethodInjectionPoint(method, references);
    }

    public PropertyInjectionPoint createPropertyInjectionPoint(Field field, String[] references) {
        if (references == null || references.length == 0) {
            references = this.fieldDefaultReferences(field);
        }
        this.removeDuplicateNames(references);
        return new PropertyInjectionPoint(field, references);
    }

    public SetInjectionPoint createSetInjectionPoint(Field field) {
        return new SetInjectionPoint(field);
    }

    protected String[] fieldDefaultReferences(Field field) {
        PetiteReference[] lookupReferences = this.petiteConfig.getLookupReferences();
        String[] references = new String[lookupReferences.length];
        block5: for (int i = 0; i < references.length; ++i) {
            switch (lookupReferences[i]) {
                case NAME: {
                    references[i] = field.getName();
                    continue block5;
                }
                case TYPE_SHORT_NAME: {
                    references[i] = StringUtil.uncapitalize((String)field.getType().getSimpleName());
                    continue block5;
                }
                case TYPE_FULL_NAME: {
                    references[i] = field.getType().getName();
                }
            }
        }
        return references;
    }

    protected String[][] methodOrCtorDefaultReferences(AccessibleObject accobj, Class[] paramTypes) {
        PetiteReference[] lookupReferences = this.petiteConfig.getLookupReferences();
        MethodParameter[] methodParameters = null;
        if (this.petiteConfig.getUseParamo()) {
            methodParameters = Paramo.resolveParameters(accobj);
        }
        String[][] references = new String[paramTypes.length][];
        for (int j = 0; j < paramTypes.length; ++j) {
            String[] ref = new String[lookupReferences.length];
            references[j] = ref;
            block6: for (int i = 0; i < ref.length; ++i) {
                switch (lookupReferences[i]) {
                    case NAME: {
                        ref[i] = methodParameters != null ? methodParameters[j].getName() : null;
                        continue block6;
                    }
                    case TYPE_SHORT_NAME: {
                        ref[i] = StringUtil.uncapitalize((String)paramTypes[j].getSimpleName());
                        continue block6;
                    }
                    case TYPE_FULL_NAME: {
                        ref[i] = paramTypes[j].getName();
                    }
                }
            }
        }
        return references;
    }

    protected void removeDuplicateNames(String[][] referencesArr) {
        for (String[] references : referencesArr) {
            this.removeDuplicateNames(references);
        }
    }

    protected void removeDuplicateNames(String[] references) {
        if (references.length < 2) {
            return;
        }
        block0: for (int i = 1; i < references.length; ++i) {
            String thisRef = references[i];
            if (thisRef == null) continue;
            for (int j = 0; j < i; ++j) {
                if (references[j] == null || !thisRef.equals(references[j])) continue;
                references[i] = null;
                continue block0;
            }
        }
    }
}

