/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.io.IOException;
import java.io.InputStream;
import jodd.io.StreamUtil;
import jodd.proxetta.ProxettaException;
import jodd.proxetta.asm.TargetClassInfoReader;
import jodd.proxetta.asm.WorkData;
import jodd.util.ClassLoaderUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public abstract class ClassProcessor {
    protected static int suffixCounter;
    protected boolean useSuffix;
    protected String classNameSuffix;
    protected ClassWriter destClassWriter;
    protected boolean proxyApplied;
    protected String proxyClassName;

    public void setUseVariableClassName(boolean useVariableClassName) {
        this.useSuffix = useVariableClassName;
    }

    public void setClassNameSuffix(String classNameSuffix) {
        this.classNameSuffix = classNameSuffix;
    }

    protected String classNameSuffix() {
        if (!this.useSuffix) {
            return this.classNameSuffix;
        }
        return this.classNameSuffix + ++suffixCounter;
    }

    protected abstract WorkData process(ClassReader var1, String var2, TargetClassInfoReader var3);

    protected ClassProcessor accept(ClassReader cr, String reqProxyClassName) {
        TargetClassInfoReader targetClassInfoReader = new TargetClassInfoReader();
        cr.accept((ClassVisitor)targetClassInfoReader, 0);
        this.destClassWriter = new ClassWriter(3);
        WorkData wd = this.process(cr, reqProxyClassName, targetClassInfoReader);
        this.proxyApplied = wd.proxyApplied;
        this.proxyClassName = wd.thisReference.replace('/', '.');
        return this;
    }

    public ClassProcessor accept(InputStream in, String reqProxyClassName) {
        ClassReader cr;
        try {
            cr = new ClassReader(in);
        }
        catch (IOException ioex) {
            throw new ProxettaException("Error reading class input stream.", ioex);
        }
        return this.accept(cr, reqProxyClassName);
    }

    public ClassProcessor accept(String targetName, String reqProxyClassName) {
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtil.getClassAsStream((String)targetName);
            ClassProcessor classProcessor = this.accept(inputStream, reqProxyClassName);
            return classProcessor;
        }
        catch (IOException ioex) {
            throw new ProxettaException("Unable to open stream for class name: " + targetName, ioex);
        }
        finally {
            StreamUtil.close((InputStream)inputStream);
        }
    }

    public ClassProcessor accept(Class target, String reqProxyClassName) {
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtil.getClassAsStream((Class)target);
            ClassProcessor classProcessor = this.accept(inputStream, reqProxyClassName);
            return classProcessor;
        }
        catch (IOException ioex) {
            throw new ProxettaException("Unable to open stream for: " + target.getName(), ioex);
        }
        finally {
            StreamUtil.close((InputStream)inputStream);
        }
    }

    protected void checkAccepted() {
        if (this.destClassWriter == null) {
            throw new ProxettaException("Target not accepted yet!");
        }
    }

    public byte[] toByteArray() {
        this.checkAccepted();
        return this.destClassWriter.toByteArray();
    }

    public boolean isProxyApplied() {
        this.checkAccepted();
        return this.proxyApplied;
    }

    public String getProxyClassName() {
        this.checkAccepted();
        return this.proxyClassName;
    }
}

