/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import jodd.db.oom.DbNameUtil;
import jodd.db.oom.meta.DbTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMetaUtil {
    public static String resolveTableName(Class<?> type, String tableNamePrefix, String tableNameSuffix, boolean toUpperCase) {
        String tableName = null;
        DbTable dbTable = type.getAnnotation(DbTable.class);
        if (dbTable != null) {
            tableName = dbTable.value().trim();
        }
        if (tableName == null || tableName.length() == 0) {
            tableName = DbNameUtil.convertClassNameToTableName(type, tableNamePrefix, tableNameSuffix, toUpperCase);
        }
        return tableName;
    }

    public static String resolveSchemaName(Class<?> type, String defaultSchemaName) {
        String schemaName = null;
        DbTable dbTable = type.getAnnotation(DbTable.class);
        if (dbTable != null) {
            schemaName = dbTable.schema().trim();
        }
        if (schemaName == null || schemaName.length() == 0) {
            schemaName = defaultSchemaName;
        }
        return schemaName;
    }

    public static boolean resolveIsAnnotated(Class<?> type) {
        DbTable dbTable = type.getAnnotation(DbTable.class);
        return dbTable != null;
    }
}

