/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import jodd.db.oom.ColumnAliasType;
import jodd.db.oom.ColumnData;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomException;
import jodd.db.oom.JoinHintResolver;
import jodd.db.oom.mapper.DefaultResultSetMapper;
import jodd.db.oom.mapper.ResultSetMapper;
import jodd.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbOomManager {
    private static DbOomManager dbOomManager = new DbOomManager();
    protected boolean tableNameUppercase = true;
    protected boolean columnNameUppercase = true;
    protected String tableNamePrefix;
    protected String tableNameSuffix;
    protected String schemaName;
    protected String[] primitiveEntitiesPrefixes = new String[]{"java.lang.", "jodd.mutable.", Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Short.TYPE.getName(), Boolean.TYPE.getName(), Byte.TYPE.getName()};
    protected Map<Class, DbEntityDescriptor> descriptors = new HashMap<Class, DbEntityDescriptor>();
    protected Map<String, DbEntityDescriptor> entityNames = new HashMap<String, DbEntityDescriptor>();
    protected Map<String, DbEntityDescriptor> tableNames = new HashMap<String, DbEntityDescriptor>();
    protected String columnAliasSeparator = "$";
    protected JoinHintResolver hintResolver = new JoinHintResolver();
    protected ColumnAliasType defaultColumnAliasType;

    protected DbOomManager() {
    }

    public static DbOomManager getInstance() {
        return dbOomManager;
    }

    public static void setInstance(DbOomManager oomManager) {
        dbOomManager = oomManager;
    }

    public void setTableNameUppercase(boolean tableNameUppercase) {
        this.tableNameUppercase = tableNameUppercase;
    }

    public boolean isTableNameUppercase() {
        return this.tableNameUppercase;
    }

    public void setColumnNameUppercase(boolean columnNameUppercase) {
        this.columnNameUppercase = columnNameUppercase;
    }

    public boolean isColumnNameUppercase() {
        return this.columnNameUppercase;
    }

    public void setTableNamePrefix(String prefix) {
        this.tableNamePrefix = prefix;
    }

    public String getTableNamePrefix() {
        return this.tableNamePrefix;
    }

    public String getTableNameSuffix() {
        return this.tableNameSuffix;
    }

    public void setTableNameSuffix(String suffix) {
        this.tableNameSuffix = suffix;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String[] getPrimitiveEntitiesPrefixes() {
        return this.primitiveEntitiesPrefixes;
    }

    public void setPrimitiveEntitiesPrefixes(String ... primitiveEntitiesPrefixes) {
        this.primitiveEntitiesPrefixes = primitiveEntitiesPrefixes;
    }

    public DbEntityDescriptor lookupType(Class type) {
        String typeName = type.getName();
        if (StringUtil.startsWithOne((String)typeName, (String[])this.primitiveEntitiesPrefixes) != -1) {
            return null;
        }
        DbEntityDescriptor ded = this.descriptors.get(type);
        if (ded == null) {
            ded = this.registerType(type);
        }
        return ded;
    }

    public boolean isRegistered(Class type) {
        return this.descriptors.containsKey(type);
    }

    public DbEntityDescriptor lookupName(String typeName) {
        return this.entityNames.get(typeName);
    }

    public DbEntityDescriptor lookupTableName(String typeName) {
        return this.tableNames.get(typeName);
    }

    public DbEntityDescriptor registerType(Class type) {
        DbEntityDescriptor ded = this.createDbEntityDescriptor(type);
        DbEntityDescriptor existing = this.descriptors.put(type, ded);
        if (existing != null) {
            throw new DbOomException("Type registration failed! Type '" + existing.getType() + "' already registered.");
        }
        existing = this.entityNames.put(ded.getEntityName(), ded);
        if (existing != null) {
            throw new DbOomException("Type registration failed! Name '" + ded.getEntityName() + "' already mapped to an entity class: " + existing.getType());
        }
        return ded;
    }

    public DbEntityDescriptor registerEntity(Class type) {
        DbEntityDescriptor ded = this.registerType(type);
        DbEntityDescriptor existing = this.tableNames.put(ded.getTableName(), ded);
        if (existing != null) {
            throw new DbOomException("Entity registration failed! Table '" + ded.getTableName() + "' already mapped to an entity class: " + existing.getType());
        }
        return ded;
    }

    public DbEntityDescriptor registerEntity(Class type, boolean force) {
        if (force) {
            this.removeEntity(type);
        }
        return this.registerEntity(type);
    }

    public DbEntityDescriptor removeEntity(Class type) {
        DbEntityDescriptor ded = this.descriptors.remove(type);
        if (ded == null) {
            ded = this.createDbEntityDescriptor(type);
        }
        this.entityNames.remove(ded.getEntityName());
        this.tableNames.remove(ded.getTableName());
        return ded;
    }

    protected DbEntityDescriptor createDbEntityDescriptor(Class type) {
        return new DbEntityDescriptor(type, this.schemaName, this.tableNamePrefix, this.tableNameSuffix, this.tableNameUppercase, this.columnNameUppercase);
    }

    public int getTotalNames() {
        return this.entityNames.size();
    }

    public int getTotalTableNames() {
        return this.tableNames.size();
    }

    public int getTotalTypes() {
        return this.descriptors.size();
    }

    public void reset() {
        this.descriptors.clear();
        this.entityNames.clear();
        this.tableNames.clear();
    }

    public String getColumnAliasSeparator() {
        return this.columnAliasSeparator;
    }

    public void setColumnAliasSeparator(String separator) {
        this.columnAliasSeparator = separator;
    }

    public JoinHintResolver getHintResolver() {
        return this.hintResolver;
    }

    public void setHintResolver(JoinHintResolver hintResolver) {
        this.hintResolver = hintResolver;
    }

    public ColumnAliasType getDefaultColumnAliasType() {
        return this.defaultColumnAliasType;
    }

    public void setDefaultColumnAliasType(ColumnAliasType defaultColumnAliasType) {
        this.defaultColumnAliasType = defaultColumnAliasType;
    }

    public ResultSetMapper createResultSetMapper(ResultSet resultSet, Map<String, ColumnData> columnAliases) {
        return new DefaultResultSetMapper(resultSet, columnAliases, this);
    }

    public <E> E createEntityInstance(Class<E> type) {
        try {
            return type.newInstance();
        }
        catch (Exception ex) {
            throw new DbOomException("Unable to create new entity instance using default constructor for type: " + type, ex);
        }
    }
}

