/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import jodd.jtx.JtxException;
import jodd.jtx.JtxResource;
import jodd.jtx.JtxResourceManager;
import jodd.jtx.JtxStatus;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.JtxTransactionMode;
import jodd.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JtxTransaction {
    private static final Log log = Log.getLogger(JtxTransaction.class);
    protected final JtxTransactionManager txManager;
    protected final JtxTransactionMode mode;
    protected final Set<JtxResource> resources;
    protected final Object context;
    protected final long deadline;
    protected final boolean startAsActive;
    protected Throwable rollbackCause;
    protected JtxStatus status;

    public JtxTransaction(JtxTransactionManager txManager, JtxTransactionMode mode, Object context, boolean active) {
        this.txManager = txManager;
        this.mode = mode;
        this.context = context;
        this.resources = new HashSet<JtxResource>();
        this.deadline = mode.getTransactionTimeout() == -1 ? -1L : System.currentTimeMillis() + (long)mode.getTransactionTimeout() * 1000L;
        this.status = active ? JtxStatus.STATUS_ACTIVE : JtxStatus.STATUS_NO_TRANSACTION;
        this.startAsActive = active;
        txManager.associateTransaction(this);
        if (log.isDebugEnabled()) {
            log.debug("New JTX {status:" + (Object)((Object)this.status) + ", mode:" + this.mode + '}');
        }
    }

    public JtxTransactionMode getTransactionMode() {
        return this.mode;
    }

    public JtxTransactionManager getTransactionManager() {
        return this.txManager;
    }

    public Object getContext() {
        return this.context;
    }

    public JtxStatus getStatus() {
        return this.status;
    }

    public boolean isStartAsActive() {
        return this.startAsActive;
    }

    public boolean isActive() {
        return this.status == JtxStatus.STATUS_ACTIVE;
    }

    public boolean isNoTransaction() {
        return this.status == JtxStatus.STATUS_NO_TRANSACTION;
    }

    public boolean isCommitted() {
        return this.status == JtxStatus.STATUS_COMMITTED;
    }

    public boolean isRolledback() {
        return this.status == JtxStatus.STATUS_ROLLEDBACK;
    }

    public boolean isCompleted() {
        return this.status == JtxStatus.STATUS_COMMITTED || this.status == JtxStatus.STATUS_ROLLEDBACK;
    }

    public void setRollbackOnly() {
        this.setRollbackOnly(null);
    }

    public void setRollbackOnly(Throwable th) {
        if (!this.isNoTransaction() && this.status != JtxStatus.STATUS_MARKED_ROLLBACK && this.status != JtxStatus.STATUS_ACTIVE) {
            throw new JtxException("There is no active transaction that can be marked as rollback only.");
        }
        this.rollbackCause = th;
        this.status = JtxStatus.STATUS_MARKED_ROLLBACK;
    }

    public boolean isRollbackOnly() {
        return this.status == JtxStatus.STATUS_MARKED_ROLLBACK;
    }

    protected void checkTimeout() {
        if (this.deadline == -1L) {
            return;
        }
        if (this.deadline - System.currentTimeMillis() < 0L) {
            this.setRollbackOnly();
            throw new JtxException("Transaction timed out, marked as rollback only.");
        }
    }

    public void commit() {
        this.checkTimeout();
        this.commitOrRollback(true);
    }

    public void rollback() {
        this.commitOrRollback(false);
    }

    protected void commitOrRollback(boolean doCommit) {
        if (log.isDebugEnabled()) {
            if (doCommit) {
                log.debug("Commit JTX");
            } else {
                log.debug("Rollback JTX");
            }
        }
        boolean forcedRollback = false;
        if (!this.isNoTransaction()) {
            if (this.isRollbackOnly()) {
                if (doCommit) {
                    doCommit = false;
                    forcedRollback = true;
                }
            } else if (!this.isActive()) {
                if (this.isCompleted()) {
                    throw new JtxException("Transaction is already completed, commit or rollback should be called once per transaction.");
                }
                throw new JtxException("No active transaction to " + (doCommit ? "commit." : "rollback."));
            }
        }
        if (doCommit) {
            this.commitAllResources();
        } else {
            this.rollbackAllResources(forcedRollback);
        }
    }

    protected void commitAllResources() throws JtxException {
        this.status = JtxStatus.STATUS_COMMITTING;
        Exception lastException = null;
        Iterator<JtxResource> it = this.resources.iterator();
        while (it.hasNext()) {
            JtxResource resource = it.next();
            try {
                resource.commitTransaction();
                it.remove();
            }
            catch (Exception ex) {
                lastException = ex;
            }
        }
        if (lastException != null) {
            this.setRollbackOnly(lastException);
            throw new JtxException("Commit failed: one or more transaction resources couldn't commit a transaction.", lastException);
        }
        this.txManager.removeTransaction(this);
        this.status = JtxStatus.STATUS_COMMITTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollbackAllResources(boolean wasForced) {
        this.status = JtxStatus.STATUS_ROLLING_BACK;
        Exception lastException = null;
        Iterator<JtxResource> it = this.resources.iterator();
        while (it.hasNext()) {
            JtxResource resource = it.next();
            try {
                resource.rollbackTransaction();
            }
            catch (Exception ex) {
                lastException = ex;
            }
            finally {
                it.remove();
            }
        }
        this.txManager.removeTransaction(this);
        this.status = JtxStatus.STATUS_ROLLEDBACK;
        if (lastException != null) {
            this.status = JtxStatus.STATUS_UNKNOWN;
            throw new JtxException("Rollback failed: one or more transaction resources couldn't rollback a transaction.", lastException);
        }
        if (wasForced) {
            throw new JtxException("Transaction rolled back because it has been marked as rollback-only.", this.rollbackCause);
        }
    }

    public <E> E requestResource(Class<E> resourceType) {
        if (this.isCompleted()) {
            throw new JtxException("Transaction is already completed, resource are not available after commit or rollback.");
        }
        if (this.isRollbackOnly()) {
            throw new JtxException("Transaction is marked as rollback only, resource are not available.", this.rollbackCause);
        }
        if (!this.isNoTransaction() && !this.isActive()) {
            throw new JtxException("Resources are not available since transaction is not active.");
        }
        this.checkTimeout();
        E resource = this.lookupResource(resourceType);
        if (resource == null) {
            int maxResources = this.txManager.getMaxResourcesPerTransaction();
            if (maxResources != -1 && this.resources.size() >= maxResources) {
                throw new JtxException("Transaction already has attached max. number of resources.");
            }
            JtxResourceManager<E> resourceManager = this.txManager.lookupResourceManager(resourceType);
            resource = resourceManager.beginTransaction(this.mode, this.isActive());
            this.resources.add(new JtxResource<E>(this, resourceManager, resource));
        }
        return resource;
    }

    protected <E> E lookupResource(Class<E> resourceType) {
        for (JtxResource jtxResource : this.resources) {
            if (!jtxResource.isSameTypeAsResource(resourceType)) continue;
            return jtxResource.getResource();
        }
        return null;
    }
}

