/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.adapter.htmlstapler;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.NetUtil;
import jodd.io.findfile.WildcardFindFile;
import jodd.lagarto.adapter.htmlstapler.BundleAction;
import jodd.lagarto.adapter.htmlstapler.HtmlStaplerException;
import jodd.log.Log;
import jodd.servlet.ServletUtil;
import jodd.util.Base32;
import jodd.util.CharUtil;
import jodd.util.StringBand;
import jodd.util.StringUtil;
import jodd.util.SystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlStaplerBundlesManager {
    private static final Log log = Log.getLogger(HtmlStaplerBundlesManager.class);
    private static final String ATTRIBUTE_NAME = HtmlStaplerBundlesManager.class.getName();
    protected int bundleCount;
    protected Map<String, String> actionBundles;
    protected Map<String, String> mirrors;
    protected String localFilesEncoding = "UTF-8";
    protected String webRoot;
    protected String bundleFolder;
    protected String staplerServletPath = "/jodd-bundle";
    protected String bundleFilenamePrefix = "jodd-bundle-";
    protected String localAddressAndPort = "http://localhost:8080";
    protected boolean downloadLocal;
    protected boolean sortResources;
    protected final String contextPath;
    protected final Strategy strategy;
    private static final Pattern CSS_URL_PATTERN = Pattern.compile("url\\s*\\(\\s*([^\\)\\s]*)\\s*\\)", 2);

    public static HtmlStaplerBundlesManager getBundlesManager(HttpServletRequest servletRequest) {
        return HtmlStaplerBundlesManager.getBundlesManager(servletRequest.getSession().getServletContext());
    }

    public static HtmlStaplerBundlesManager getBundlesManager(ServletContext servletContext) {
        return (HtmlStaplerBundlesManager)servletContext.getAttribute(ATTRIBUTE_NAME);
    }

    public HtmlStaplerBundlesManager(ServletContext servletContext, Strategy strategy) {
        this.strategy = strategy;
        servletContext.setAttribute(ATTRIBUTE_NAME, (Object)this);
        this.webRoot = servletContext.getRealPath("");
        this.bundleFolder = SystemUtil.getTempDir();
        this.contextPath = ServletUtil.getContextPath((ServletContext)servletContext);
        if (strategy == Strategy.ACTION_MANAGED) {
            this.actionBundles = new HashMap<String, String>();
            this.mirrors = new HashMap<String, String>();
        }
    }

    public BundleAction start(HttpServletRequest servletRequest, String bundleName) {
        return new BundleAction(this, servletRequest, bundleName);
    }

    public Strategy getStrategy() {
        return this.strategy;
    }

    public boolean isSortResources() {
        return this.sortResources;
    }

    public void setSortResources(boolean sortResources) {
        this.sortResources = sortResources;
    }

    public String getWebRoot() {
        return this.webRoot;
    }

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public String getBundleFolder() {
        return this.bundleFolder;
    }

    public void setBundleFolder(String bundleFolder) {
        this.bundleFolder = bundleFolder;
    }

    public String getStaplerServletPath() {
        return this.staplerServletPath;
    }

    public void setStaplerServletPath(String staplerServletPath) {
        this.staplerServletPath = staplerServletPath;
    }

    public String getBundleFilenamePrefix() {
        return this.bundleFilenamePrefix;
    }

    public void setBundleFilenamePrefix(String bundleFilenamePrefix) {
        this.bundleFilenamePrefix = bundleFilenamePrefix;
    }

    public String getLocalFilesEncoding() {
        return this.localFilesEncoding;
    }

    public void setLocalFilesEncoding(String localFilesEncoding) {
        this.localFilesEncoding = localFilesEncoding;
    }

    public String getLocalAddressAndPort() {
        return this.localAddressAndPort;
    }

    public void setLocalAddressAndPort(String localAddressAndPort) {
        this.localAddressAndPort = localAddressAndPort;
    }

    public boolean isDownloadLocal() {
        return this.downloadLocal;
    }

    public void setDownloadLocal(boolean downloadLocal) {
        this.downloadLocal = downloadLocal;
    }

    protected File createBundleFile(String bundleId) {
        return new File(this.bundleFolder, this.bundleFilenamePrefix + bundleId);
    }

    public File lookupBundleFile(String bundleId) {
        String realBundleId;
        if (this.mirrors != null && !this.mirrors.isEmpty() && (realBundleId = this.mirrors.remove(bundleId)) != null) {
            bundleId = realBundleId;
        }
        return this.createBundleFile(bundleId);
    }

    public String lookupBundleId(String actionPath) {
        return this.actionBundles.get(actionPath);
    }

    public String registerNewBundleId() {
        ++this.bundleCount;
        return String.valueOf(this.bundleCount);
    }

    public synchronized String registerBundle(String contextPath, String actionPath, String tempBundleId, List<String> sources) {
        if (tempBundleId == null || sources.isEmpty()) {
            if (this.strategy == Strategy.ACTION_MANAGED) {
                this.actionBundles.put(actionPath, "");
            }
            return null;
        }
        Object[] sourcesArray = sources.toArray(new String[sources.size()]);
        int sourcesArrayLength = sourcesArray.length;
        for (int i = 0; i < sourcesArrayLength; ++i) {
            sourcesArray[i] = sourcesArray[i].trim().toLowerCase();
        }
        if (this.sortResources) {
            Arrays.sort(sourcesArray);
        }
        StringBand sb = new StringBand(sourcesArray.length);
        for (Object src : sourcesArray) {
            sb.append((String)src);
        }
        String sourcesString = sb.toString();
        String digest = this.createDigest(sourcesString);
        if (this.strategy == Strategy.ACTION_MANAGED) {
            this.actionBundles.put(actionPath, digest);
            this.mirrors.put(tempBundleId, digest);
        }
        try {
            this.createBundle(contextPath, actionPath, digest, sources);
        }
        catch (IOException ioex) {
            throw new HtmlStaplerException("Can't create bundle.", ioex);
        }
        return digest;
    }

    protected String createDigest(String source) {
        MessageDigest shaDigester;
        try {
            shaDigester = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException nsaex) {
            throw new HtmlStaplerException(nsaex);
        }
        byte[] bytes = shaDigester.digest(CharUtil.toSimpleByteArray((CharSequence)source));
        return Base32.encode((byte[])bytes);
    }

    protected void createBundle(String contextPath, String actionPath, String bundleId, List<String> sources) throws IOException {
        File bundleFile = this.createBundleFile(bundleId);
        if (bundleFile.exists()) {
            return;
        }
        StringBand sb = new StringBand(sources.size() * 2);
        for (String src : sources) {
            String content;
            if (sb.length() != 0) {
                sb.append("\n");
            }
            if (this.isExternalResource(src)) {
                content = NetUtil.downloadString((String)src, (String)this.localFilesEncoding);
            } else {
                if (!this.downloadLocal) {
                    int qmndx;
                    String localFile = this.webRoot;
                    if (src.startsWith(contextPath + '/')) {
                        src = src.substring(contextPath.length());
                    }
                    if ((qmndx = (localFile = src.startsWith("/") ? localFile + src : localFile + '/' + FileNameUtil.getPathNoEndSeparator((String)actionPath) + '/' + src).indexOf(63)) != -1) {
                        localFile = localFile.substring(0, qmndx);
                    }
                    content = FileUtil.readString((String)localFile);
                } else {
                    String localUrl = this.localAddressAndPort;
                    localUrl = src.startsWith("/") ? localUrl + contextPath + src : localUrl + contextPath + FileNameUtil.getPath((String)actionPath) + '/' + src;
                    content = NetUtil.downloadString((String)localUrl, (String)this.localFilesEncoding);
                }
                if (this.isCssResource(src)) {
                    content = this.fixCssRelativeUrls(content, src);
                }
            }
            content = this.onResourceContent(content);
            sb.append(content);
        }
        FileUtil.writeString((File)bundleFile, (String)sb.toString());
        if (log.isInfoEnabled()) {
            log.info("Bundle created: " + bundleId);
        }
    }

    protected boolean isExternalResource(String link) {
        return link.startsWith("http://") || link.startsWith("https://");
    }

    protected String onResourceContent(String content) {
        return content;
    }

    protected String resolveRealActionPath(String actionPath) {
        return actionPath;
    }

    public synchronized void reset() {
        File f;
        if (this.strategy == Strategy.ACTION_MANAGED) {
            this.actionBundles.clear();
            this.mirrors.clear();
        }
        WildcardFindFile ff = new WildcardFindFile("*/" + this.bundleFilenamePrefix + "*");
        ff.setIncludeDirs(false);
        ff.searchPath(this.bundleFolder);
        int count = 0;
        while ((f = ff.nextFile()) != null) {
            f.delete();
            ++count;
        }
        if (log.isInfoEnabled()) {
            log.info("HtmlStapler reset, " + count + " bundle files deleted.");
        }
    }

    protected boolean isCssResource(String src) {
        return src.endsWith(".css");
    }

    protected String fixCssRelativeUrls(String content, String src) {
        String path = FileNameUtil.getPath((String)src);
        Matcher matcher = CSS_URL_PATTERN.matcher(content);
        StringBuilder sb = new StringBuilder(content.length());
        int start = 0;
        while (matcher.find()) {
            sb.append(content.substring(start, matcher.start()));
            String url = this.fixRelativeUrl(matcher.group(1), path);
            sb.append(url);
            start = matcher.end();
        }
        sb.append(content.substring(start));
        return sb.toString();
    }

    protected String fixRelativeUrl(String url, String offsetPath) {
        url = StringUtil.removeChars((String)url, (String)"'\"");
        StringBuilder res = new StringBuilder();
        res.append("url('");
        if (!url.startsWith("/")) {
            res.append(offsetPath);
        }
        res.append(url);
        res.append("')");
        return res.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        ACTION_MANAGED,
        RESOURCES_ONLY;

    }
}

