/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.adapter.htmlstapler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.io.StreamUtil;
import jodd.io.ZipUtil;
import jodd.lagarto.adapter.htmlstapler.HtmlStaplerBundlesManager;
import jodd.log.Log;
import jodd.servlet.ServletUtil;
import jodd.typeconverter.Convert;

public class HtmlStaplerServlet
extends HttpServlet {
    protected HtmlStaplerBundlesManager bundlesManager;
    protected boolean useGzip;
    private static final Log log = Log.getLogger(HtmlStaplerServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.bundlesManager = HtmlStaplerBundlesManager.getBundlesManager(config.getServletContext());
        this.useGzip = Convert.toBooleanValue((Object)config.getInitParameter("gzip"), (boolean)false);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String bundleId = request.getParameter("id");
        File file = this.bundlesManager.lookupBundleFile(bundleId);
        if (log.isDebugEnabled()) {
            log.debug("bundle: " + bundleId);
        }
        if (this.useGzip && ServletUtil.isGzipSupported((HttpServletRequest)request)) {
            file = this.lookupGzipBundleFile(file);
            response.setHeader("Content-Encoding", "gzip");
        }
        this.sendBundleFile(response, file);
    }

    protected void sendBundleFile(HttpServletResponse resp, File bundleFile) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        StreamUtil.copy((InputStream)new FileInputStream(bundleFile), (OutputStream)out);
    }

    protected File lookupGzipBundleFile(File file) throws IOException {
        String path = file.getPath() + ".gz";
        File gzipFile = new File(path);
        if (!gzipFile.exists()) {
            if (log.isDebugEnabled()) {
                log.debug("gzip bundle to " + path);
            }
            ZipUtil.gzip((File)file);
        }
        return gzipFile;
    }
}

