/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import jodd.lagarto.Tag;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.dom.CData;
import jodd.lagarto.dom.Comment;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.DocumentType;
import jodd.lagarto.dom.Element;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.Text;
import jodd.lagarto.dom.XmlDeclaration;
import jodd.log.Log;

public class DOMBuilderTagVisitor
implements TagVisitor {
    private static final Log log = Log.getLogger(DOMBuilderTagVisitor.class);
    protected final LagartoDOMBuilder builder;
    private long startTime;
    protected Document rootNode;
    protected Node parentNode;

    public DOMBuilderTagVisitor(LagartoDOMBuilder builder) {
        this.builder = builder;
    }

    public Document getDocument() {
        return this.rootNode;
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("DomTree builder started.");
        }
        this.rootNode = new Document();
        this.parentNode = this.rootNode;
    }

    public void end() {
        if (this.parentNode != this.rootNode) {
            log.warn("Some tags are not closed.");
            this.fixUpToMatchingPoint(this.rootNode);
        }
        if (this.builder.isIgnoreWhitespacesBetweenTags()) {
            this.removeLastChildNodeIfEmptyText(this.parentNode, true);
        }
        if (log.isDebugEnabled()) {
            long elapsed = System.currentTimeMillis() - this.startTime;
            log.debug("DomTree created in " + elapsed + " ms.");
        }
    }

    protected Element createElementNode(Tag tag) {
        boolean isVoid = this.builder.isVoidTag(tag.getName());
        boolean selfClosed = false;
        if (this.builder.hasVoidTags()) {
            if (isVoid) {
                selfClosed = this.builder.isSelfCloseVoidTags();
            }
        } else {
            selfClosed = this.builder.isSelfCloseVoidTags();
        }
        return new Element(tag, isVoid, selfClosed, this.builder.isCaseSensitive());
    }

    public void tag(Tag tag) {
        TagType tagType = tag.getType();
        switch (tagType) {
            case START: {
                if (this.builder.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, false);
                }
                Element node = this.createElementNode(tag);
                this.parentNode.appendChild((Node)node);
                if (node.isVoidElement()) break;
                this.parentNode = node;
                break;
            }
            case END: {
                String tagName;
                Node matchingParent;
                if (this.builder.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, true);
                }
                if ((matchingParent = this.findMatchingParentOpenTag(tagName = tag.getName())) == this.parentNode) {
                    this.parentNode = this.parentNode.getParentNode();
                    break;
                }
                if (matchingParent == null) {
                    if (!log.isWarnEnabled()) break;
                    log.warn("Orphan closed tag: </" + tagName + "> ignored.");
                    break;
                }
                this.fixUpToMatchingPoint(matchingParent);
                break;
            }
            case SELF_CLOSING: {
                if (this.builder.isIgnoreWhitespacesBetweenTags()) {
                    this.removeLastChildNodeIfEmptyText(this.parentNode, false);
                }
                Element node = this.createElementNode(tag);
                this.parentNode.appendChild((Node)node);
            }
        }
    }

    protected void removeLastChildNodeIfEmptyText(Node parentNode, boolean closedTag) {
        if (parentNode == null) {
            return;
        }
        Node lastChild = parentNode.getLastChild();
        if (lastChild == null) {
            return;
        }
        if (lastChild.getNodeType() != Node.NodeType.TEXT) {
            return;
        }
        if (closedTag && parentNode.getChildNodesCount() == 1) {
            return;
        }
        Text text = (Text)lastChild;
        if (text.isBlank()) {
            lastChild.detachFromParent();
        }
    }

    protected Node findMatchingParentOpenTag(String tagName) {
        Node parent = this.parentNode;
        if (!this.builder.isCaseSensitive()) {
            tagName = tagName.toLowerCase();
        }
        while (parent != null) {
            String parentNodeName = parent.getNodeName();
            if (parentNodeName != null && !this.builder.isCaseSensitive()) {
                parentNodeName = parentNodeName.toLowerCase();
            }
            if (tagName.equals(parentNodeName)) {
                return parent;
            }
            parent = parent.getParentNode();
        }
        return null;
    }

    protected void fixUpToMatchingPoint(Node matchingParent) {
        while (true) {
            int ndx;
            String nodeName = this.parentNode.getNodeName();
            if (this.parentNode == matchingParent) break;
            Node[] childNodes = this.parentNode.getChildNodes();
            this.parentNode.removeAllChilds();
            for (ndx = 0; ndx < childNodes.length; ++ndx) {
                Node child = childNodes[ndx];
                if (child.getNodeType() == Node.NodeType.TEXT && ((Text)child).isBlank()) {
                    this.parentNode.appendChild(child);
                    continue;
                }
                this.parentNode.appendChild(child);
                break;
            }
            Node parentParentNode = this.parentNode.getParentNode();
            ++ndx;
            while (ndx < childNodes.length) {
                Node child = childNodes[ndx];
                parentParentNode.appendChild(child);
                ++ndx;
            }
            if (log.isWarnEnabled()) {
                log.warn("Unclosed tag: <" + nodeName + "> closed.");
            }
            this.parentNode = parentParentNode;
        }
        this.parentNode = this.parentNode.getParentNode();
    }

    public void xmp(Tag tag, CharSequence body) {
        Element node = this.createElementNode(tag);
        this.parentNode.appendChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(((Object)body).toString());
            node.appendChild((Node)text);
        }
    }

    public void style(Tag tag, CharSequence body) {
        Element node = this.createElementNode(tag);
        this.parentNode.appendChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(((Object)body).toString());
            node.appendChild((Node)text);
        }
    }

    public void script(Tag tag, CharSequence body) {
        Element node = this.createElementNode(tag);
        this.parentNode.appendChild((Node)node);
        if (body.length() != 0) {
            Text text = new Text(((Object)body).toString());
            node.appendChild((Node)text);
        }
    }

    public void comment(CharSequence comment) {
        if (this.builder.isIgnoreWhitespacesBetweenTags()) {
            this.removeLastChildNodeIfEmptyText(this.parentNode, false);
        }
        if (this.builder.isIgnoreComments()) {
            return;
        }
        Comment node = new Comment(((Object)comment).toString());
        this.parentNode.appendChild((Node)node);
    }

    public void text(CharSequence text) {
        String textValue = ((Object)text).toString();
        Text node = new Text(textValue);
        this.parentNode.appendChild((Node)node);
    }

    public void cdata(CharSequence cdata) {
        CData cdataNode = new CData(((Object)cdata).toString());
        this.parentNode.appendChild((Node)cdataNode);
    }

    public void xml(Tag tag) {
        XmlDeclaration xmlDeclaration = new XmlDeclaration(tag, this.builder.isCaseSensitive());
        this.parentNode.appendChild((Node)xmlDeclaration);
    }

    public void doctype(String name, String publicId, String baseUri) {
        DocumentType documentType = new DocumentType(name, publicId, baseUri);
        this.parentNode.appendChild((Node)documentType);
    }

    public void condComment(CharSequence conditionalComment, boolean isStartingTag, boolean isDownlevelHidden) {
        Comment comment = new Comment(((Object)conditionalComment).toString(), isStartingTag, isDownlevelHidden);
        this.parentNode.appendChild((Node)comment);
    }

    public void error(String message) {
        if (log.isWarnEnabled()) {
            log.warn("DOM tree may be corrupted due to parsing error. " + message);
        }
    }
}

