/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import java.nio.CharBuffer;
import jodd.lagarto.LagartoParser;
import jodd.lagarto.dom.DOMBuilderTagVisitor;
import jodd.lagarto.dom.Document;
import jodd.util.StringUtil;

public class LagartoDOMBuilder {
    public static final String[] HTML5_VOID_TAGS = new String[]{"area", "base", "br", "col", "command", "embed", "hr", "img", "input", "keygen", "link", "meta", "param", "source", "track", "wbr"};
    protected boolean ignoreWhitespacesBetweenTags;
    protected boolean caseSensitive;
    protected boolean parseSpecialTagsAsCdata = true;
    protected boolean ignoreComments;
    protected boolean selfCloseVoidTags;
    protected String[] voidTags = HTML5_VOID_TAGS;

    public boolean isIgnoreWhitespacesBetweenTags() {
        return this.ignoreWhitespacesBetweenTags;
    }

    public void setIgnoreWhitespacesBetweenTags(boolean ignoreWhitespacesBetweenTags) {
        this.ignoreWhitespacesBetweenTags = ignoreWhitespacesBetweenTags;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isParseSpecialTagsAsCdata() {
        return this.parseSpecialTagsAsCdata;
    }

    public void setParseSpecialTagsAsCdata(boolean parseSpecialTagsAsCdata) {
        this.parseSpecialTagsAsCdata = parseSpecialTagsAsCdata;
    }

    public boolean isIgnoreComments() {
        return this.ignoreComments;
    }

    public void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }

    public String[] getVoidTags() {
        return this.voidTags;
    }

    public void setVoidTags(String ... voidTags) {
        this.voidTags = voidTags;
    }

    public boolean hasVoidTags() {
        return this.voidTags != null;
    }

    public boolean isVoidTag(String tagName) {
        if (this.voidTags == null) {
            return false;
        }
        return StringUtil.equalsOne((String)(tagName = tagName.toLowerCase()), (String[])this.voidTags) != -1;
    }

    public boolean isSelfCloseVoidTags() {
        return this.selfCloseVoidTags;
    }

    public void setSelfCloseVoidTags(boolean selfCloseVoidTags) {
        this.selfCloseVoidTags = selfCloseVoidTags;
    }

    public LagartoDOMBuilder enableHtmlMode() {
        this.ignoreWhitespacesBetweenTags = false;
        this.caseSensitive = false;
        this.parseSpecialTagsAsCdata = true;
        this.voidTags = HTML5_VOID_TAGS;
        this.selfCloseVoidTags = false;
        return this;
    }

    public LagartoDOMBuilder enableXhtmlMode() {
        this.ignoreWhitespacesBetweenTags = false;
        this.caseSensitive = true;
        this.parseSpecialTagsAsCdata = false;
        this.voidTags = HTML5_VOID_TAGS;
        this.selfCloseVoidTags = true;
        return this;
    }

    public LagartoDOMBuilder enableXmlMode() {
        this.ignoreWhitespacesBetweenTags = true;
        this.caseSensitive = true;
        this.parseSpecialTagsAsCdata = false;
        this.voidTags = null;
        this.selfCloseVoidTags = false;
        return this;
    }

    public Document parse(CharSequence content) {
        LagartoParser lagarto = new LagartoParser(content);
        return this.parse(lagarto);
    }

    public Document parse(CharBuffer content) {
        LagartoParser lagarto = new LagartoParser(content);
        return this.parse(lagarto);
    }

    protected Document parse(LagartoParser lagarto) {
        DOMBuilderTagVisitor domBuilderTagVisitor = new DOMBuilderTagVisitor(this);
        lagarto.parse(domBuilderTagVisitor, this.parseSpecialTagsAsCdata);
        return domBuilderTagVisitor.getDocument();
    }
}

