/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.MadvocException;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.injector.BaseScopeInjector;
import jodd.madvoc.injector.ScopeData;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.FileUpload;
import jodd.servlet.upload.MultipartRequestWrapper;
import jodd.util.StringUtil;

public class RequestScopeInjector
extends BaseScopeInjector {
    protected final String encoding;
    protected final Config config;
    protected final MadvocConfig.AttrNames attrNames;

    public RequestScopeInjector(MadvocConfig madvocConfig) {
        super(ScopeType.REQUEST);
        this.encoding = madvocConfig.getEncoding();
        this.config = madvocConfig.getRequestScopeInjectorConfig().clone();
        this.attrNames = madvocConfig.getAttrNames();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Config getConfig() {
        return this.config;
    }

    protected void injectAttributes(Object target, ScopeData.In[] injectData, HttpServletRequest servletRequest) {
        Enumeration attributeNames = servletRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            for (ScopeData.In in : injectData) {
                String name = this.getMatchedPropertyName(in, attrName);
                if (name == null) continue;
                Object attrValue = servletRequest.getAttribute(attrName);
                this.setTargetProperty(target, name, attrValue, in.create);
                if (!in.remove) continue;
                servletRequest.removeAttribute(attrName);
            }
        }
    }

    protected void injectParameters(Object target, ScopeData.In[] injectData, HttpServletRequest servletRequest) {
        boolean encode = this.config.encodeGetParams && servletRequest.getMethod().equals("GET");
        Enumeration paramNames = servletRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            for (ScopeData.In in : injectData) {
                String name = this.getMatchedPropertyName(in, paramName);
                if (name == null) continue;
                String[] paramValues = servletRequest.getParameterValues(paramName);
                if ((paramValues = ServletUtil.prepareParameters((String[])paramValues, (boolean)this.config.trimParams, (boolean)this.config.treatEmptyParamsAsNull, (boolean)this.config.ignoreEmptyRequestParams)) == null) continue;
                if (encode) {
                    for (int i = 0; i < paramValues.length; ++i) {
                        String p = paramValues[i];
                        if (p == null) continue;
                        try {
                            paramValues[i] = StringUtil.convertCharset((String)p, (String)"ISO-8859-1", (String)this.encoding);
                            continue;
                        }
                        catch (UnsupportedEncodingException unex) {
                            // empty catch block
                        }
                    }
                }
                String[] value = paramValues.length != 1 ? paramValues : paramValues[0];
                this.setTargetProperty(target, name, value, in.create);
            }
        }
    }

    protected void injectUploadedFiles(Object target, ScopeData.In[] injectData, HttpServletRequest servletRequest) {
        if (!(servletRequest instanceof MultipartRequestWrapper)) {
            return;
        }
        MultipartRequestWrapper multipartRequest = (MultipartRequestWrapper)servletRequest;
        if (!multipartRequest.isMultipart()) {
            return;
        }
        Enumeration paramNames = multipartRequest.getFileParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (servletRequest.getAttribute(paramName) != null) continue;
            for (ScopeData.In in : injectData) {
                String name = this.getMatchedPropertyName(in, paramName);
                if (name == null) continue;
                FileUpload paramValues = multipartRequest.getFiles(paramName);
                if (this.config.ignoreInvalidUploadFiles) {
                    for (int i = 0; i < ((FileUpload[])paramValues).length; ++i) {
                        FileUpload paramValue = paramValues[i];
                        if (paramValue.isValid() && paramValue.isUploaded()) continue;
                        paramValues[i] = null;
                    }
                }
                FileUpload value = ((FileUpload[])paramValues).length == 1 ? paramValues[0] : paramValues;
                this.setTargetProperty(target, name, value, in.create);
            }
        }
    }

    protected void outjectMoveSource(HttpServletRequest servletRequest) {
        String moveId = servletRequest.getParameter(this.attrNames.moveId);
        if (moveId != null) {
            HttpSession session = servletRequest.getSession();
            ActionRequest sourceRequest = (ActionRequest)session.getAttribute(moveId);
            session.removeAttribute(moveId);
            if (sourceRequest != null) {
                this.outject(sourceRequest.getAction(), servletRequest);
            }
        }
    }

    public void prepare(HttpServletRequest servletRequest) {
        if (this.config.copyParamsToAttributes) {
            ServletUtil.copyParamsToAttributes((HttpServletRequest)servletRequest, (boolean)this.config.trimParams, (boolean)this.config.treatEmptyParamsAsNull, (boolean)this.config.ignoreEmptyRequestParams);
        }
        this.outjectMoveSource(servletRequest);
    }

    public void inject(Object target, HttpServletRequest servletRequest) {
        ScopeData.In[] injectData = this.lookupInData(target.getClass());
        if (injectData == null) {
            return;
        }
        if (this.config.injectAttributes) {
            this.injectAttributes(target, injectData, servletRequest);
        }
        if (this.config.injectParameters) {
            this.injectParameters(target, injectData, servletRequest);
            this.injectUploadedFiles(target, injectData, servletRequest);
        }
    }

    public void outject(Object target, HttpServletRequest servletRequest) {
        ScopeData.Out[] outjectData = this.lookupOutData(target.getClass());
        if (outjectData == null) {
            return;
        }
        for (ScopeData.Out out : outjectData) {
            Object value = this.getTargetProperty(target, out);
            servletRequest.setAttribute(out.name, value);
        }
    }

    public static class Config
    implements Cloneable {
        protected boolean ignoreEmptyRequestParams;
        protected boolean treatEmptyParamsAsNull;
        protected boolean injectAttributes = true;
        protected boolean injectParameters = true;
        protected boolean copyParamsToAttributes;
        protected boolean trimParams;
        protected boolean encodeGetParams;
        protected boolean ignoreInvalidUploadFiles = true;

        public boolean isIgnoreEmptyRequestParams() {
            return this.ignoreEmptyRequestParams;
        }

        public void setIgnoreEmptyRequestParams(boolean ignoreEmptyRequestParams) {
            this.ignoreEmptyRequestParams = ignoreEmptyRequestParams;
        }

        public boolean isTreatEmptyParamsAsNull() {
            return this.treatEmptyParamsAsNull;
        }

        public void setTreatEmptyParamsAsNull(boolean treatEmptyParamsAsNull) {
            this.treatEmptyParamsAsNull = treatEmptyParamsAsNull;
        }

        public boolean isInjectAttributes() {
            return this.injectAttributes;
        }

        public void setInjectAttributes(boolean injectAttributes) {
            this.injectAttributes = injectAttributes;
        }

        public boolean isInjectParameters() {
            return this.injectParameters;
        }

        public void setInjectParameters(boolean injectParameters) {
            this.injectParameters = injectParameters;
        }

        public boolean isCopyParamsToAttributes() {
            return this.copyParamsToAttributes;
        }

        public void setCopyParamsToAttributes(boolean copyParamsToAttributes) {
            this.copyParamsToAttributes = copyParamsToAttributes;
        }

        public boolean isTrimParams() {
            return this.trimParams;
        }

        public void setTrimParams(boolean trimParams) {
            this.trimParams = trimParams;
        }

        public boolean isEncodeGetParams() {
            return this.encodeGetParams;
        }

        public void setEncodeGetParams(boolean encodeGetParams) {
            this.encodeGetParams = encodeGetParams;
        }

        public boolean isIgnoreInvalidUploadFiles() {
            return this.ignoreInvalidUploadFiles;
        }

        public void setIgnoreInvalidUploadFiles(boolean ignoreInvalidUploadFiles) {
            this.ignoreInvalidUploadFiles = ignoreInvalidUploadFiles;
        }

        public Config clone() {
            try {
                return (Config)super.clone();
            }
            catch (CloneNotSupportedException cnsex) {
                throw new MadvocException(cnsex);
            }
        }
    }
}

