/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jodd.db.DbDefault;
import jodd.db.DbQueryParser;
import jodd.db.DbSession;
import jodd.db.DbSqlException;
import jodd.db.LoggablePreparedStatement;
import jodd.db.ResultSetUtil;
import jodd.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DbQueryBase {
    private static final Log log = Log.getLogger(DbQueryBase.class);
    public static final int QUERY_CREATED = 1;
    public static final int QUERY_INITIALIZED = 2;
    public static final int QUERY_CLOSED = 3;
    protected int queryState = 1;
    protected Connection connection;
    protected DbSession session;
    protected String sqlString;
    protected Statement statement;
    protected PreparedStatement preparedStatement;
    protected Set<ResultSet> resultSets;
    protected DbQueryParser query;
    protected boolean forcePreparedStatement = DbDefault.forcePreparedStatement;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    protected int type = DbDefault.type;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    protected int concurrencyType = DbDefault.concurrencyType;
    public static final int DEFAULT_HOLDABILITY = -1;
    public static final int CLOSE_CURSORS_AT_COMMIT = 2;
    public static final int HOLD_CURSORS_OVER_COMMIT = 1;
    protected int holdability = DbDefault.holdability;
    protected boolean debug = DbDefault.debug;
    protected String[] generatedColumns;
    protected int fetchSize = DbDefault.fetchSize;
    protected int maxRows = DbDefault.maxRows;
    protected static int totalOpenResultSetCount;

    DbQueryBase() {
    }

    public int getQueryState() {
        return this.queryState;
    }

    protected void checkNotClosed() {
        if (this.queryState == 3) {
            throw new DbSqlException("Query is closed. Operation may be performed only on active queries.");
        }
    }

    protected void checkCreated() {
        if (this.queryState != 1) {
            String message = this.queryState == 2 ? "Query is already initialized." : "Query is closed.";
            throw new DbSqlException(message + " Operation may be performed only on created queries.");
        }
    }

    protected void checkInitialized() {
        if (this.queryState != 2) {
            String message = this.queryState == 1 ? "Query is just created and not yet initialized." : "Query is closed.";
            throw new DbSqlException(message + " Operation may be performed only on initialized queries.");
        }
    }

    public boolean isClosed() {
        return this.queryState == 3;
    }

    public boolean isActive() {
        return this.queryState < 3;
    }

    public boolean isInitialized() {
        return this.queryState == 2;
    }

    protected void saveResultSet(ResultSet rs) {
        if (this.resultSets == null) {
            this.resultSets = new HashSet<ResultSet>();
        }
        this.resultSets.add(rs);
    }

    public void forcePreparedStatement() {
        this.checkCreated();
        this.forcePreparedStatement = true;
    }

    public final void init() {
        this.checkNotClosed();
        if (this.queryState == 2) {
            return;
        }
        this.initializeJdbc();
        this.queryState = 2;
        this.prepareQuery();
    }

    protected void initializeJdbc() {
        if (this.connection == null) {
            if (this.session == null) {
                this.session = DbDefault.sessionProvider.getDbSession();
            }
            this.connection = this.session.getConnection();
        }
        this.query = new DbQueryParser(this.sqlString);
        if (!this.forcePreparedStatement && !this.query.prepared) {
            try {
                this.statement = this.holdability != -1 ? this.connection.createStatement(this.type, this.concurrencyType, this.holdability) : this.connection.createStatement(this.type, this.concurrencyType);
            }
            catch (SQLException sex) {
                throw new DbSqlException("Unable to create statement.", sex);
            }
            return;
        }
        try {
            this.statement = this.debug ? (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? new LoggablePreparedStatement(this.connection, this.query.sql, 1) : new LoggablePreparedStatement(this.connection, this.query.sql, this.generatedColumns)) : (this.holdability != -1 ? new LoggablePreparedStatement(this.connection, this.query.sql, this.type, this.concurrencyType, this.holdability) : new LoggablePreparedStatement(this.connection, this.query.sql, this.type, this.concurrencyType))) : (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? this.connection.prepareStatement(this.query.sql, 1) : this.connection.prepareStatement(this.query.sql, this.generatedColumns)) : (this.holdability != -1 ? this.connection.prepareStatement(this.query.sql, this.type, this.concurrencyType, this.holdability) : this.connection.prepareStatement(this.query.sql, this.type, this.concurrencyType)));
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to create prepared statement.", sex);
        }
        this.preparedStatement = (PreparedStatement)this.statement;
    }

    protected void prepareQuery() {
        if (this.fetchSize != 0) {
            this.setFetchSize(this.fetchSize);
        }
        if (this.maxRows != 0) {
            this.setMaxRows(this.maxRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SQLException> closeQueryResultSets() {
        ArrayList<SQLException> sexs = null;
        if (this.resultSets != null) {
            for (ResultSet rs : this.resultSets) {
                try {
                    rs.close();
                }
                catch (SQLException sex) {
                    if (sexs == null) {
                        sexs = new ArrayList<SQLException>();
                    }
                    sexs.add(sex);
                }
                finally {
                    --totalOpenResultSetCount;
                }
            }
            this.resultSets.clear();
            this.resultSets = null;
        }
        return sexs;
    }

    public void closeAllResultSets() {
        List<SQLException> sexs = this.closeQueryResultSets();
        if (sexs != null) {
            throw new DbSqlException("Unable to close associated ResultSets.", sexs);
        }
    }

    protected List<SQLException> closeQuery() {
        List<SQLException> sexs = this.closeQueryResultSets();
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sex) {
                if (sexs == null) {
                    sexs = new ArrayList<SQLException>();
                }
                sexs.add(sex);
            }
            this.statement = null;
        }
        this.query = null;
        this.queryState = 3;
        return sexs;
    }

    public void close() {
        List<SQLException> sexs = this.closeQuery();
        this.connection = null;
        if (this.session != null) {
            this.session.detachQuery(this);
        }
        if (sexs != null) {
            throw new DbSqlException("Unable to close query.", sexs);
        }
    }

    public void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        if (!this.resultSets.remove(rs)) {
            throw new DbSqlException("Provided ResultSet is not created by this query and should be not closed in this way.");
        }
        try {
            rs.close();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to close the result set.", sex);
        }
        finally {
            --totalOpenResultSetCount;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.checkCreated();
        this.type = type;
    }

    public void typeForwardOnly() {
        this.setType(1003);
    }

    public void typeScrollSensitive() {
        this.setType(1005);
    }

    public void typeScrollInsensitive() {
        this.setType(1005);
    }

    public int getConcurrencyType() {
        return this.concurrencyType;
    }

    public void setConcurrencyType(int concurrencyType) {
        this.checkCreated();
        this.concurrencyType = concurrencyType;
    }

    public void concurReadOnly() {
        this.setConcurrencyType(1007);
    }

    public void concurUpdatable() {
        this.setConcurrencyType(1008);
    }

    public int getHoldability() {
        return this.holdability;
    }

    public void setHoldability(int holdability) {
        this.checkCreated();
        this.holdability = holdability;
    }

    public void holdCursorsOverCommit() {
        this.setHoldability(1);
    }

    public void closeCursorsAtCommit() {
        this.setHoldability(2);
    }

    public boolean isInDebugMode() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.checkCreated();
        this.debug = debug;
    }

    public void setDebugMode() {
        this.setDebug(true);
    }

    public String[] getGeneratedColumnNames() {
        return this.generatedColumns;
    }

    public void setGeneratedColumns(String ... columns) {
        this.checkCreated();
        this.generatedColumns = columns;
    }

    public void setGeneratedKey() {
        this.setGeneratedColumns(new String[0]);
    }

    public void resetGeneratedColumns() {
        this.checkCreated();
        this.generatedColumns = null;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int rows) {
        this.checkNotClosed();
        this.fetchSize = rows;
        if (this.statement != null) {
            try {
                this.statement.setFetchSize(this.fetchSize);
            }
            catch (SQLException sex) {
                throw new DbSqlException("Unable to set fetch size of: " + this.fetchSize, sex);
            }
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.checkNotClosed();
        this.maxRows = maxRows;
        if (this.statement != null) {
            try {
                this.statement.setMaxRows(maxRows);
            }
            catch (SQLException sex) {
                throw new DbSqlException("Unable to set max rows of: " + maxRows, sex);
            }
        }
    }

    public ResultSet execute() {
        this.init();
        ResultSet rs = null;
        if (log.isDebugEnabled()) {
            log.debug("Executing statement: " + this.getQueryString());
        }
        try {
            rs = this.preparedStatement == null ? this.statement.executeQuery(this.query.sql) : this.preparedStatement.executeQuery();
            rs.setFetchSize(this.fetchSize);
        }
        catch (SQLException sex) {
            ResultSetUtil.close(rs);
            throw new DbSqlException("Unable to execute query.", sex);
        }
        this.saveResultSet(rs);
        ++totalOpenResultSetCount;
        return rs;
    }

    public int executeUpdate() {
        return this.executeUpdate(false);
    }

    public int executeUpdateAndClose() {
        return this.executeUpdate(true);
    }

    protected int executeUpdate(boolean closeQuery) {
        int result;
        this.init();
        if (log.isDebugEnabled()) {
            log.debug("Executing update: " + this.getQueryString());
        }
        try {
            result = this.preparedStatement == null ? (this.generatedColumns != null ? (this.generatedColumns.length == 0 ? this.statement.executeUpdate(this.query.sql, 1) : this.statement.executeUpdate(this.query.sql, this.generatedColumns)) : this.statement.executeUpdate(this.query.sql)) : this.preparedStatement.executeUpdate();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to execute the query.", sex);
        }
        if (closeQuery) {
            this.close();
        }
        return result;
    }

    public long executeCount() {
        return this.executeCount(false);
    }

    public long executeCountAndClose() {
        return this.executeCount(true);
    }

    protected long executeCount(boolean close) {
        long l;
        this.init();
        ResultSet rs = null;
        if (log.isDebugEnabled()) {
            log.debug("Executing prepared count: " + this.getQueryString());
        }
        try {
            rs = this.preparedStatement == null ? this.statement.executeQuery(this.query.sql) : this.preparedStatement.executeQuery();
            l = ResultSetUtil.getFirstLong(rs);
        }
        catch (SQLException sex) {
            try {
                throw new DbSqlException("Unable to execute count query.", sex);
            }
            catch (Throwable throwable) {
                ResultSetUtil.close(rs);
                if (close) {
                    this.close();
                }
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        if (close) {
            this.close();
        }
        return l;
    }

    public ResultSet getGeneratedColumns() {
        ResultSet rs;
        this.checkInitialized();
        if (this.generatedColumns == null) {
            throw new DbSqlException("No column is specified as auto-generated.");
        }
        try {
            rs = this.statement.getGeneratedKeys();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to return generated keys.", sex);
        }
        this.saveResultSet(rs);
        ++totalOpenResultSetCount;
        return rs;
    }

    public long getGeneratedKey() {
        this.checkInitialized();
        ResultSet rs = this.getGeneratedColumns();
        try {
            long l = ResultSetUtil.getFirstLong(rs);
            return l;
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to get generated key as long value.", sex);
        }
        finally {
            ResultSetUtil.close(rs);
            this.resultSets.remove(rs);
            --totalOpenResultSetCount;
        }
    }

    public String getQueryString() {
        if (this.preparedStatement != null && this.preparedStatement instanceof LoggablePreparedStatement) {
            return ((LoggablePreparedStatement)this.preparedStatement).getQueryString();
        }
        if (this.query != null) {
            return this.query.sql;
        }
        return this.sqlString;
    }

    public String toString() {
        return this.getQueryString();
    }

    public static int getTotalOpenResultSetCount() {
        return totalOpenResultSetCount;
    }

    public int getOpenResultSetCount() {
        return this.resultSets == null ? 0 : this.resultSets.size();
    }
}

