/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jodd.bean.BeanUtil;
import jodd.db.oom.ColumnData;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomException;
import jodd.db.oom.DbOomManager;
import jodd.db.oom.mapper.ResultSetMapper;
import jodd.db.type.SqlType;
import jodd.db.type.SqlTypeManager;
import jodd.typeconverter.TypeConverterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResultSetMapper
implements ResultSetMapper {
    protected final DbOomManager dbOomManager;
    protected final ResultSet rs;
    protected final int totalColumns;
    protected final String[] columnNames;
    protected final int[] columnDbSqlTypes;
    protected final String[] tableNames;
    private final Set<String> resultColumns;
    protected Class[] cachedUsedTypes;
    protected String[] cachedTypesTableNames;
    protected int cachedColumnNdx;
    protected Object cachedColumnValue;

    public DefaultResultSetMapper(ResultSet rs, DbOomManager dbOomManager) {
        this(rs, null, dbOomManager);
    }

    public DefaultResultSetMapper(ResultSet rs, Map<String, ColumnData> columnAliases, DbOomManager oomManager) {
        this.dbOomManager = oomManager;
        this.rs = rs;
        this.resultColumns = new HashSet<String>();
        try {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            if (rsMetaData == null) {
                throw new DbOomException("JDBC driver does not provide meta-data.");
            }
            this.totalColumns = rsMetaData.getColumnCount();
            this.columnNames = new String[this.totalColumns];
            this.columnDbSqlTypes = new int[this.totalColumns];
            this.tableNames = new String[this.totalColumns];
            for (int i = 0; i < this.totalColumns; ++i) {
                ColumnData columnData;
                String columnName = rsMetaData.getColumnName(i + 1);
                String tableName = null;
                int sepNdx = columnName.indexOf(this.dbOomManager.getColumnAliasSeparator());
                if (sepNdx != -1) {
                    tableName = columnName.substring(0, sepNdx);
                    if (columnAliases != null && (columnData = columnAliases.get(tableName)) != null) {
                        tableName = columnData.getTableName();
                    }
                    columnName = columnName.substring(sepNdx + 1);
                } else {
                    if (columnAliases != null && (columnData = columnAliases.get(columnName.toLowerCase())) != null) {
                        tableName = columnData.getTableName();
                        columnName = columnData.getColumnName();
                    }
                    if (tableName == null) {
                        try {
                            tableName = rsMetaData.getTableName(i + 1);
                        }
                        catch (SQLException sex) {
                            // empty catch block
                        }
                        if (tableName != null && tableName.length() == 0) {
                            tableName = null;
                        }
                    }
                }
                columnName = columnName.trim();
                if (columnName.length() == 0) {
                    columnName = null;
                }
                if (columnName != null) {
                    columnName = columnName.trim();
                }
                this.columnNames[i] = columnName;
                if (tableName != null) {
                    tableName = tableName.trim();
                }
                this.tableNames[i] = tableName;
                this.columnDbSqlTypes[i] = rsMetaData.getColumnType(i + 1);
            }
        }
        catch (SQLException sex) {
            throw new DbOomException("Unable to read ResultSet meta-data.", sex);
        }
    }

    @Override
    public boolean next() {
        try {
            return this.rs.next();
        }
        catch (SQLException sex) {
            throw new DbOomException("Unable to move ResultSet cursor to next position.", sex);
        }
    }

    @Override
    public void close() {
        try {
            this.rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public ResultSet getResultSet() {
        return this.rs;
    }

    @Override
    public Class[] resolveTables() {
        ArrayList<Class> classes = new ArrayList<Class>(this.tableNames.length);
        String lastTableName = null;
        this.resultColumns.clear();
        for (int i = 0; i < this.tableNames.length; ++i) {
            String tableName = this.tableNames[i];
            String columnName = this.columnNames[i];
            if (!tableName.equals(lastTableName) || this.resultColumns.contains(columnName)) {
                this.resultColumns.clear();
                lastTableName = tableName;
                DbEntityDescriptor ded = this.dbOomManager.lookupTableName(tableName);
                if (ded == null) {
                    throw new DbOomException("Table name '" + tableName + "' not registered.");
                }
                classes.add(ded.getType());
            }
            this.resultColumns.add(columnName);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected String[] createTypesTableNames(Class[] types) {
        if (types != this.cachedUsedTypes) {
            this.cachedTypesTableNames = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null) {
                    this.cachedTypesTableNames[i] = null;
                    continue;
                }
                DbEntityDescriptor ded = this.dbOomManager.lookupType(types[i]);
                if (ded == null) continue;
                this.cachedTypesTableNames[i] = ded.getTableName();
            }
            this.cachedUsedTypes = types;
        }
        return this.cachedTypesTableNames;
    }

    protected Object readColumnValue(int colNdx, Class destinationType, Class<? extends SqlType> sqlTypeClass, int columnDbSqlType) {
        if (colNdx != this.cachedColumnNdx) {
            try {
                SqlType sqlType = sqlTypeClass != null ? SqlTypeManager.lookupSqlType(sqlTypeClass) : SqlTypeManager.lookup(destinationType);
                if (sqlType != null) {
                    this.cachedColumnValue = sqlType.readValue(this.rs, colNdx + 1, destinationType, columnDbSqlType);
                } else {
                    this.cachedColumnValue = this.rs.getObject(colNdx + 1);
                    this.cachedColumnValue = TypeConverterManager.convertType((Object)this.cachedColumnValue, (Class)destinationType);
                }
            }
            catch (SQLException sex) {
                throw new DbOomException("Unable to read value for column #" + (colNdx + 1), sex);
            }
            this.cachedColumnNdx = colNdx;
        }
        return this.cachedColumnValue;
    }

    @Override
    public Object[] parseObjects(Class ... types) {
        this.resultColumns.clear();
        int totalTypes = types.length;
        Object[] result = new Object[totalTypes];
        boolean[] resultUsage = new boolean[totalTypes];
        String[] typesTableNames = this.createTypesTableNames(types);
        int currentResult = 0;
        this.cachedColumnNdx = -1;
        int colNdx = 0;
        while (colNdx < this.totalColumns && currentResult < totalTypes) {
            Class currentType = types[currentResult];
            if (currentType == null) {
                ++colNdx;
                ++currentResult;
                this.resultColumns.clear();
                continue;
            }
            String columnName = this.columnNames[colNdx];
            int columnDbSqlType = this.columnDbSqlTypes[colNdx];
            String tableName = this.tableNames[colNdx];
            String resultTableName = typesTableNames[currentResult];
            if (resultTableName == null) {
                result[currentResult] = this.readColumnValue(colNdx, currentType, null, columnDbSqlType);
                resultUsage[currentResult] = true;
                ++colNdx;
                ++currentResult;
                this.resultColumns.clear();
                continue;
            }
            if ((tableName == null || resultTableName.equals(tableName)) && !this.resultColumns.contains(columnName)) {
                String propertyName;
                DbEntityDescriptor ded = this.dbOomManager.lookupType(currentType);
                DbEntityColumnDescriptor dec = ded.findByColumnName(columnName);
                String string = propertyName = dec == null ? null : dec.getPropertyName();
                if (propertyName != null) {
                    Class type;
                    if (result[currentResult] == null) {
                        result[currentResult] = this.dbOomManager.createEntityInstance(currentType);
                    }
                    if ((type = BeanUtil.getDeclaredPropertyType((Object)result[currentResult], (String)propertyName)) != null) {
                        dec.updateDbSqlType(columnDbSqlType);
                        Class<? extends SqlType> sqlTypeClass = dec.getSqlTypeClass();
                        Object value = this.readColumnValue(colNdx, type, sqlTypeClass, columnDbSqlType);
                        if (value != null) {
                            BeanUtil.setDeclaredProperty((Object)result[currentResult], (String)propertyName, (Object)value);
                            resultUsage[currentResult] = true;
                        }
                        ++colNdx;
                        this.resultColumns.add(columnName);
                        continue;
                    }
                }
            }
            ++currentResult;
            this.resultColumns.clear();
        }
        this.resultColumns.clear();
        for (int i = 0; i < resultUsage.length; ++i) {
            if (resultUsage[i]) continue;
            result[i] = null;
        }
        return result;
    }

    @Override
    public Object parseOneObject(Class ... types) {
        return this.parseObjects(types)[0];
    }
}

