/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx.db;

import jodd.db.DbSession;
import jodd.db.DbSessionProvider;
import jodd.db.DbSqlException;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.JtxTransactionMode;
import jodd.jtx.db.DbJtxTransaction;
import jodd.log.Log;

public class DbJtxSessionProvider
implements DbSessionProvider {
    private static final Log log = Log.getLogger(DbJtxSessionProvider.class);
    protected final JtxTransactionManager jtxTxManager;
    protected final JtxTransactionMode defaultTxMode;

    public DbJtxSessionProvider(JtxTransactionManager txManager) {
        this(txManager, null);
    }

    public DbJtxSessionProvider(JtxTransactionManager txManager, JtxTransactionMode defaultTxMode) {
        this.jtxTxManager = txManager;
        this.defaultTxMode = defaultTxMode;
    }

    public DbSession getDbSession() {
        DbJtxTransaction jtx;
        if (log.isDebugEnabled()) {
            log.debug("Requesting db TX manager session");
        }
        if ((jtx = (DbJtxTransaction)this.jtxTxManager.getTransaction()) == null) {
            if (this.defaultTxMode != null) {
                jtx = (DbJtxTransaction)this.jtxTxManager.requestTransaction(this.defaultTxMode, null);
                return jtx.requestResource();
            }
            throw new DbSqlException("No transaction is in progress and DbSession can't be provided. It seems that transaction manager is not used to begin a transaction.");
        }
        return jtx.requestResource();
    }

    public void closeDbSession() {
        DbJtxTransaction jtx;
        if (log.isDebugEnabled()) {
            log.debug("Closing db TX manager session");
        }
        if ((jtx = (DbJtxTransaction)this.jtxTxManager.getTransaction()) != null) {
            jtx.commit();
        }
    }
}

