/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.adapter.htmlstapler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.datetime.TimeUtil;
import jodd.io.StreamUtil;
import jodd.lagarto.adapter.htmlstapler.HtmlStaplerBundlesManager;
import jodd.log.Log;
import jodd.servlet.ServletUtil;
import jodd.typeconverter.Convert;
import jodd.util.MimeTypes;

public class HtmlStaplerServlet
extends HttpServlet {
    protected HtmlStaplerBundlesManager bundlesManager;
    protected boolean useGzip;
    private static final Log log = Log.getLogger(HtmlStaplerServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.bundlesManager = HtmlStaplerBundlesManager.getBundlesManager(config.getServletContext());
        this.useGzip = Convert.toBooleanValue((Object)config.getInitParameter("gzip"), (boolean)false);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String bundleId = request.getParameter("id");
        File file = this.bundlesManager.lookupBundleFile(bundleId);
        if (log.isDebugEnabled()) {
            log.debug("bundle: " + bundleId);
        }
        int ndx = bundleId.lastIndexOf(45);
        String extension = bundleId.substring(ndx + 1);
        String contentType = MimeTypes.getMimeType((String)extension);
        response.setContentType(contentType);
        if (this.useGzip && ServletUtil.isGzipSupported((HttpServletRequest)request)) {
            file = this.bundlesManager.lookupGzipBundleFile(file);
            response.setHeader("Content-Encoding", "gzip");
        }
        if (!file.exists()) {
            throw new ServletException("bundle not found: " + bundleId);
        }
        response.setHeader("Content-Length", String.valueOf(file.length()));
        response.setHeader("Last-Modified", TimeUtil.formatHttpDate((long)file.lastModified()));
        this.sendBundleFile(response, file);
    }

    protected void sendBundleFile(HttpServletResponse resp, File bundleFile) throws IOException {
        ServletOutputStream out = resp.getOutputStream();
        StreamUtil.copy((InputStream)new FileInputStream(bundleFile), (OutputStream)out);
    }
}

