/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.log.Log;
import jodd.madvoc.Madvoc;
import jodd.madvoc.component.MadvocController;
import jodd.servlet.DispatcherUtil;

public class MadvocServletFilter
implements Filter {
    private static Log log;
    protected Madvoc madvoc;
    protected MadvocController madvocController;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        this.madvoc = Madvoc.get(servletContext);
        if (this.madvoc == null) {
            this.madvoc = this.createMadvoc(filterConfig);
            try {
                this.madvoc.startNewWebApplication(servletContext);
            }
            catch (Exception ex) {
                throw new ServletException("Unable to start Madvoc web application.", (Throwable)ex);
            }
        }
        log = Log.getLogger(MadvocServletFilter.class);
        this.madvocController = this.madvoc.getMadvocController();
    }

    protected Madvoc createMadvoc(FilterConfig filterConfig) {
        Madvoc madvoc = new Madvoc();
        madvoc.configure(filterConfig);
        return madvoc;
    }

    public void destroy() {
        this.madvoc.stopWebApplication();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String actionPath = DispatcherUtil.getServletPath((HttpServletRequest)request);
        try {
            actionPath = this.madvocController.invoke(actionPath, request, response);
        }
        catch (Exception ex) {
            log.error("Exception while invoking action path: " + actionPath, ex);
            ex.printStackTrace();
            throw new ServletException((Throwable)ex);
        }
        if (actionPath != null && (actionPath = this.processUnhandledPath(actionPath, req, res)) != null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected String processUnhandledPath(String actionPath, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        return actionPath;
    }
}

