/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ContextInjector;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.injector.ActionPathMacroInjector;
import jodd.madvoc.injector.RequestScopeInjector;
import jodd.madvoc.injector.SessionScopeInjector;
import jodd.madvoc.interceptor.ActionInterceptor;
import jodd.madvoc.meta.In;
import jodd.servlet.ServletUtil;
import jodd.servlet.upload.MultipartRequestWrapper;

public class ServletConfigInterceptor
extends ActionInterceptor {
    @In(scope=ScopeType.CONTEXT)
    protected MadvocConfig madvocConfig;
    @In(scope=ScopeType.CONTEXT)
    protected ContextInjector contextInjector;
    protected RequestScopeInjector requestScopeInjector;
    protected SessionScopeInjector sessionScopeInjector;
    protected ActionPathMacroInjector actionPathMacroInjector;

    public void init() {
        this.requestScopeInjector = new RequestScopeInjector(this.madvocConfig);
        this.sessionScopeInjector = new SessionScopeInjector();
        this.actionPathMacroInjector = new ActionPathMacroInjector();
    }

    public Object intercept(ActionRequest actionRequest) throws Exception {
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        if (ServletUtil.isMultipartRequest((HttpServletRequest)servletRequest)) {
            servletRequest = new MultipartRequestWrapper(servletRequest, this.madvocConfig.getFileUploadFactory(), this.madvocConfig.getEncoding());
            actionRequest.setHttpServletRequest(servletRequest);
        }
        this.inject(actionRequest);
        Object result = actionRequest.invoke();
        this.outject(actionRequest);
        return result;
    }

    protected void inject(ActionRequest actionRequest) {
        Object target = actionRequest.getAction();
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        this.contextInjector.injectContext(target, servletRequest, servletResponse, false);
        this.sessionScopeInjector.inject(target, servletRequest);
        this.requestScopeInjector.prepare(servletRequest);
        this.requestScopeInjector.inject(target, servletRequest);
        this.actionPathMacroInjector.inject(target, actionRequest);
    }

    protected void outject(ActionRequest actionRequest) {
        Object target = actionRequest.getAction();
        HttpServletRequest servletRequest = actionRequest.getHttpServletRequest();
        HttpServletResponse servletResponse = actionRequest.getHttpServletResponse();
        this.contextInjector.outjectContext(target, servletRequest, servletResponse);
        this.sessionScopeInjector.outject(target, servletRequest);
        this.requestScopeInjector.outject(target, servletRequest);
    }
}

