/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import jodd.petite.CtorInjectionPoint;
import jodd.petite.InitMethodPoint;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.SetInjectionPoint;
import jodd.petite.WiringMode;
import jodd.petite.scope.Scope;
import jodd.util.ArraysUtil;

public class BeanDefinition {
    public final String name;
    public final Class type;
    protected final Scope scope;
    public final WiringMode wiringMode;
    public CtorInjectionPoint ctor;
    public PropertyInjectionPoint[] properties;
    public SetInjectionPoint[] sets;
    public MethodInjectionPoint[] methods;
    public InitMethodPoint[] initMethods;
    public String[] params;

    public BeanDefinition(String name, Class type, Scope scope, WiringMode wiringMode) {
        this.name = name;
        this.type = type;
        this.scope = scope;
        this.wiringMode = wiringMode;
    }

    public Object scopeLookup() {
        return this.scope.lookup(this.name);
    }

    public void scopeRegister(Object object) {
        this.scope.register(this.name, object);
    }

    public void scopeRemove() {
        this.scope.remove(this.name);
    }

    public void addPropertyInjectionPoint(PropertyInjectionPoint pip) {
        if (this.properties == null) {
            this.properties = new PropertyInjectionPoint[1];
            this.properties[0] = pip;
        } else {
            this.properties = (PropertyInjectionPoint[])ArraysUtil.append((Object[])this.properties, (Object)pip);
        }
    }

    public void addSetInjectionPoint(SetInjectionPoint sip) {
        if (this.sets == null) {
            this.sets = new SetInjectionPoint[1];
            this.sets[0] = sip;
        } else {
            this.sets = (SetInjectionPoint[])ArraysUtil.append((Object[])this.sets, (Object)sip);
        }
    }

    public void addMethodInjectionPoint(MethodInjectionPoint mip) {
        if (this.methods == null) {
            this.methods = new MethodInjectionPoint[1];
            this.methods[0] = mip;
        } else {
            this.methods = (MethodInjectionPoint[])ArraysUtil.append((Object[])this.methods, (Object)mip);
        }
    }

    public void addInitMethodPoints(InitMethodPoint[] methods) {
        this.initMethods = this.initMethods == null ? methods : (InitMethodPoint[])ArraysUtil.join((Object[])this.initMethods, (Object[])methods);
    }

    public String toString() {
        return "BeanDefinition{name='" + this.name + '\'' + ", type=" + this.type + ", scope=" + this.scope + '}';
    }
}

