/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import jodd.bean.BeanUtil;
import jodd.db.DbQueryBase;
import jodd.db.DbSession;
import jodd.db.DbSqlException;
import jodd.db.type.SqlType;
import jodd.db.type.SqlTypeManager;
import jodd.io.AsciiInputStream;
import jodd.log.Log;
import jodd.util.collection.IntArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbQuery
extends DbQueryBase {
    private static final Log log = Log.getLogger(DbQuery.class);

    public DbQuery(Connection conn, String sqlString) {
        this.connection = conn;
        this.sqlString = sqlString;
        if (log.isDebugEnabled()) {
            log.debug("DbQuery: " + sqlString);
        }
    }

    public DbQuery(DbSession session, String sqlString) {
        if (session == null) {
            session = this.dbManager.sessionProvider.getDbSession();
        }
        this.session = session;
        session.attachQuery(this);
        this.sqlString = sqlString;
        if (log.isDebugEnabled()) {
            log.debug("DbQuery: " + sqlString);
        }
    }

    public DbQuery(String sqlString) {
        this((DbSession)null, sqlString);
    }

    public void clearParameters() {
        this.init();
        if (this.preparedStatement == null) {
            return;
        }
        try {
            this.preparedStatement.clearParameters();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to clear parameters", sex);
        }
    }

    private void throwSetParamError(int index, Exception ex) {
        throw new DbSqlException("Unable to set SQL parameter with index: " + index, ex);
    }

    private void throwSetParamError(String param, Exception ex) {
        throw new DbSqlException("Unable to set SQL parameter with name: " + param, ex);
    }

    public void setNull(int index, int type) {
        this.init();
        try {
            this.preparedStatement.setNull(index, type);
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to set null value to parameter: " + index, sex);
        }
    }

    public void setNull(String param, int type) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setNull(positions.get(i), type);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to set null value to parameter: " + param, sex);
        }
    }

    public void setNull(int index, int type, String typeName) {
        this.init();
        try {
            this.preparedStatement.setNull(index, type, typeName);
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to set null value to parameter: " + index, sex);
        }
    }

    public void setNull(String param, int value, String typeName) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setNull(positions.get(i), value, typeName);
            }
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to set null value to parameter: " + param, sex);
        }
    }

    public void setInteger(int index, int value) {
        this.init();
        try {
            this.preparedStatement.setInt(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setInteger(String param, int value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setInt(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setInteger(int index, Number value) {
        if (value == null) {
            this.setNull(index, 4);
            return;
        }
        this.setInteger(index, value.intValue());
    }

    public void setInteger(String param, Number value) {
        if (value == null) {
            this.setNull(param, 4);
            return;
        }
        this.setInteger(param, value.intValue());
    }

    public void setBoolean(int index, boolean value) {
        this.init();
        try {
            this.preparedStatement.setBoolean(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setBoolean(String param, boolean value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setBoolean(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setBoolean(int index, Boolean value) {
        if (value == null) {
            this.setNull(index, 16);
            return;
        }
        this.setBoolean(index, (boolean)value);
    }

    public void setBoolean(String param, Boolean value) {
        if (value == null) {
            this.setNull(param, 16);
            return;
        }
        this.setBoolean(param, (boolean)value);
    }

    public void setLong(int index, long value) {
        this.init();
        try {
            this.preparedStatement.setLong(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setLong(String param, long value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setLong(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setLong(int index, Number value) {
        if (value == null) {
            this.setNull(index, 4);
            return;
        }
        this.setLong(index, value.longValue());
    }

    public void setLong(String param, Number value) {
        if (value == null) {
            this.setNull(param, 4);
            return;
        }
        this.setLong(param, value.longValue());
    }

    public void setByte(int index, byte value) {
        this.init();
        try {
            this.preparedStatement.setByte(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setByte(String param, byte value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setByte(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setByte(int index, Number value) {
        if (value == null) {
            this.setNull(index, 5);
            return;
        }
        this.setByte(index, value.byteValue());
    }

    public void setByte(String param, Number value) {
        if (value == null) {
            this.setNull(param, 5);
            return;
        }
        this.setByte(param, value.byteValue());
    }

    public void setBytes(int index, byte[] value) {
        this.init();
        try {
            this.preparedStatement.setBytes(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setBytes(String param, byte[] value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setBytes(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setDouble(int index, double value) {
        this.init();
        try {
            this.preparedStatement.setDouble(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setDouble(String param, double value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setDouble(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setDouble(int index, Number value) {
        if (value == null) {
            this.setNull(index, 8);
            return;
        }
        this.setDouble(index, value.doubleValue());
    }

    public void setDouble(String param, Number value) {
        if (value == null) {
            this.setNull(param, 8);
            return;
        }
        this.setDouble(param, value.doubleValue());
    }

    public void setFloat(int index, float value) {
        this.init();
        try {
            this.preparedStatement.setFloat(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setFloat(String param, float value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setFloat(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setFloat(int index, Number value) {
        if (value == null) {
            this.setNull(index, 6);
            return;
        }
        this.setFloat(index, value.floatValue());
    }

    public void setFloat(String param, Number value) {
        if (value == null) {
            this.setNull(param, 6);
            return;
        }
        this.setFloat(param, value.floatValue());
    }

    public void setShort(int index, short value) {
        this.init();
        try {
            this.preparedStatement.setShort(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setShort(String param, short value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                int index = positions.get(i);
                this.preparedStatement.setShort(index, value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setShort(int index, Number value) {
        if (value == null) {
            this.setNull(index, 5);
            return;
        }
        this.setShort(index, value.shortValue());
    }

    public void setShort(String param, Number value) {
        if (value == null) {
            this.setNull(param, 5);
            return;
        }
        this.setShort(param, value.shortValue());
    }

    public void setString(int index, String value) {
        this.init();
        try {
            this.preparedStatement.setString(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setString(String param, String value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setString(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setDate(int index, Date value) {
        this.init();
        try {
            this.preparedStatement.setDate(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setDate(String param, Date value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setDate(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setTime(int index, Time value) {
        this.init();
        try {
            this.preparedStatement.setTime(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setTime(String param, Time value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setTime(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setTimestamp(int index, Timestamp value) {
        this.init();
        try {
            this.preparedStatement.setTimestamp(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setTimestamp(String param, Timestamp value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setTimestamp(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setBigDecimal(int index, BigDecimal value) {
        this.init();
        try {
            this.preparedStatement.setBigDecimal(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setBigDecimal(String param, BigDecimal value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setBigDecimal(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setBigInteger(int index, BigInteger value) {
        if (value == null) {
            this.setNull(index, 2);
            return;
        }
        this.setLong(index, value.longValue());
    }

    public void setBigInteger(String param, BigInteger value) {
        if (value == null) {
            this.setNull(param, 2);
            return;
        }
        this.setLong(param, value.longValue());
    }

    public void setURL(int index, URL value) {
        this.init();
        try {
            this.preparedStatement.setURL(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setURL(String param, URL value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setURL(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setBlob(int index, Blob value) {
        this.init();
        try {
            this.preparedStatement.setBlob(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setBlob(String param, Blob value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setBlob(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setClob(int index, Clob value) {
        this.init();
        try {
            this.preparedStatement.setClob(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setClob(String param, Clob value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setClob(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setArray(int index, Array value) {
        this.init();
        try {
            this.preparedStatement.setArray(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setArray(String param, Array value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setArray(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setRef(int index, Ref value) {
        this.init();
        try {
            this.preparedStatement.setRef(index, value);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setRef(String param, Ref value) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setRef(positions.get(i), value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setAsciiStream(int index, AsciiInputStream stream) {
        this.init();
        try {
            this.preparedStatement.setAsciiStream(index, (InputStream)stream, stream.available());
        }
        catch (IOException ioex) {
            this.throwSetParamError(index, (Exception)ioex);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setAsciiStream(String param, AsciiInputStream stream) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setAsciiStream(positions.get(i), (InputStream)stream, stream.available());
            }
        }
        catch (IOException ioex) {
            this.throwSetParamError(param, (Exception)ioex);
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setAsciiStream(int index, InputStream stream, int length) {
        this.init();
        try {
            this.preparedStatement.setAsciiStream(index, stream, length);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setAsciiStream(String param, InputStream stream, int length) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setAsciiStream(positions.get(i), stream, length);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setCharacterStream(int index, Reader reader, int length) {
        this.init();
        try {
            this.preparedStatement.setCharacterStream(index, reader, length);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setCharacterStream(String param, Reader reader, int length) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setCharacterStream(positions.get(i), reader, length);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setBean(String beanName, Object bean) {
        if (bean == null) {
            return;
        }
        this.init();
        beanName = beanName + '.';
        Iterator<String> it = this.query.iterateNamedParameters();
        while (it.hasNext()) {
            String propertyName;
            String paramName = it.next();
            if (!paramName.startsWith(beanName) || !BeanUtil.hasDeclaredProperty((Object)bean, (String)(propertyName = paramName.substring(beanName.length())))) continue;
            Object value = BeanUtil.getDeclaredProperty((Object)bean, (String)propertyName);
            this.setObject(paramName, value);
        }
    }

    public void setMap(Map parameters) {
        if (parameters == null) {
            return;
        }
        this.init();
        Iterator<String> it = this.query.iterateNamedParameters();
        while (it.hasNext()) {
            String paramName = it.next();
            this.setObject(paramName, parameters.get(paramName));
        }
    }

    public void setObject(int index, Object object, int targetSqlType) {
        this.init();
        try {
            this.preparedStatement.setObject(index, object, targetSqlType);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setObject(String param, Object object, int targetSqlType) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setObject(positions.get(i), object, targetSqlType);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    void setObject(int index, Object object, int targetSqlType, int scale) {
        this.init();
        try {
            this.preparedStatement.setObject(index, object, targetSqlType, scale);
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    void setObject(String param, Object object, int targetSqlType, int scale) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        try {
            for (int i = 0; i < positions.size(); ++i) {
                this.preparedStatement.setObject(positions.get(i), object, targetSqlType, scale);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(param, (Exception)sex);
        }
    }

    public void setObject(int index, Object value) {
        this.setObject(index, value, null, 1111);
    }

    public void setObject(int index, Object value, Class<? extends SqlType> sqlTypeClass, int dbSqlType) {
        this.init();
        if (value == null) {
            this.setNull(index, 0);
            return;
        }
        SqlType sqlType = sqlTypeClass != null ? SqlTypeManager.lookupSqlType(sqlTypeClass) : SqlTypeManager.lookup(value.getClass());
        try {
            if (sqlType != null) {
                sqlType.storeValue(this.preparedStatement, index, value, dbSqlType);
            } else {
                this.preparedStatement.setObject(index, value);
            }
        }
        catch (SQLException sex) {
            this.throwSetParamError(index, (Exception)sex);
        }
    }

    public void setObject(String param, Object value) {
        this.setObject(param, value, null, 1111);
    }

    public void setObject(String param, Object value, Class<? extends SqlType> sqlTypeClass, int dbSqlType) {
        this.init();
        IntArrayList positions = this.query.getNamedParameterIndices(param);
        for (int i = 0; i < positions.size(); ++i) {
            this.setObject(positions.get(i), value, sqlTypeClass, dbSqlType);
        }
    }

    public void setObjects(Object ... objects) {
        int index = 1;
        for (Object object : objects) {
            this.setObject(index++, object);
        }
    }

    public void setObjects(String[] names, Object[] values) {
        this.init();
        if (names.length != values.length) {
            throw new DbSqlException("Different number of parameter names and values.");
        }
        for (int i = 0; i < names.length; ++i) {
            this.setObject(names[i], values[i]);
        }
    }
}

