/*
 * Decompiled with CFR 0.152.
 */
package jodd.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jodd.db.DbManager;
import jodd.db.DbQueryBase;
import jodd.db.DbSqlException;
import jodd.db.DbTransactionMode;
import jodd.db.connection.ConnectionProvider;
import jodd.log.Log;

public class DbSession {
    private static final Log log = Log.getLogger(DbSession.class);
    protected final DbManager dbManager = DbManager.getInstance();
    protected final ConnectionProvider connectionProvider;
    protected Connection connection;
    protected Set<DbQueryBase> queries;
    protected boolean txActive;
    protected DbTransactionMode txMode;

    public DbSession() {
        this(null);
    }

    public DbSession(ConnectionProvider connectionProvider) {
        if (log.isDebugEnabled()) {
            log.debug("Creating new db session");
        }
        if (connectionProvider == null && (connectionProvider = this.dbManager.connectionProvider) == null) {
            throw new DbSqlException("Connection provider is not available.");
        }
        this.connectionProvider = connectionProvider;
        this.txActive = false;
        this.txMode = this.dbManager.transactionMode;
        this.queries = new HashSet<DbQueryBase>();
    }

    public void closeSession() {
        if (log.isDebugEnabled()) {
            log.debug("Closing db session");
        }
        ArrayList<SQLException> allsexs = null;
        for (DbQueryBase query : this.queries) {
            List<SQLException> sexs = query.closeQuery();
            if (sexs == null) continue;
            if (allsexs == null) {
                allsexs = new ArrayList<SQLException>();
            }
            allsexs.addAll(sexs);
        }
        if (this.connection != null) {
            if (this.txActive) {
                throw new DbSqlException("Transaction was not closed before closing the session.");
            }
            this.connectionProvider.closeConnection(this.connection);
            this.connection = null;
        }
        this.queries = null;
        if (allsexs != null) {
            throw new DbSqlException("Unable to close DbSession.", allsexs);
        }
    }

    public boolean isSessionClosed() {
        return this.queries == null;
    }

    public int getTotalQueries() {
        return this.queries.size();
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void attachQuery(DbQueryBase query) {
        this.checkOpenSession();
        this.openConnectionForQuery();
        this.queries.add(query);
    }

    protected void detachQuery(DbQueryBase query) {
        this.queries.remove(query);
    }

    protected void openConnectionForQuery() {
        if (this.connection == null) {
            this.connection = this.connectionProvider.getConnection();
            this.txActive = false;
            try {
                this.connection.setAutoCommit(true);
            }
            catch (SQLException sex) {
                throw new DbSqlException("Unable to open non-transactional connection.", sex);
            }
        }
    }

    public boolean isTransactionActive() {
        return this.txActive;
    }

    protected void openTx() {
        if (this.connection == null) {
            this.connection = this.connectionProvider.getConnection();
        }
        this.txActive = true;
        try {
            this.connection.setAutoCommit(false);
            if (this.txMode.getIsolation() != -1) {
                this.connection.setTransactionIsolation(this.txMode.getIsolation());
            }
            this.connection.setReadOnly(this.txMode.isReadOnly());
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to open and prepare transaction.", sex);
        }
    }

    protected void closeTx() {
        this.txActive = false;
        try {
            this.connection.setAutoCommit(true);
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to prepare connection", sex);
        }
    }

    public void beginTransaction(DbTransactionMode mode) {
        if (log.isDebugEnabled()) {
            log.debug("Beginning transaction");
        }
        this.checkClosedTx();
        this.txMode = mode;
        this.openTx();
    }

    public void beginTransaction() {
        this.beginTransaction(this.dbManager.transactionMode);
    }

    public void commitTransaction() {
        if (log.isDebugEnabled()) {
            log.debug("Committing transaction");
        }
        this.checkActiveTx();
        try {
            this.connection.commit();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to commit transaction.", sex);
        }
        finally {
            this.closeTx();
        }
    }

    public void rollbackTransaction() {
        if (log.isDebugEnabled()) {
            log.debug("Rolling-back transaction");
        }
        this.checkActiveTx();
        try {
            this.connection.rollback();
        }
        catch (SQLException sex) {
            throw new DbSqlException("Unable to rollback transaction.", sex);
        }
        finally {
            this.closeTx();
        }
    }

    protected void checkOpenSession() {
        if (this.queries == null) {
            throw new DbSqlException("Session is already closed.");
        }
    }

    protected void checkClosedTx() {
        this.checkOpenSession();
        if (this.txActive) {
            throw new DbSqlException("Transaction already started for this session.");
        }
    }

    protected void checkActiveTx() {
        this.checkOpenSession();
        if (!this.txActive) {
            throw new DbSqlException("Transaction not available for this session.");
        }
    }
}

